/*
 * Decompiled with CFR 0.152.
 */
package de.breakpointsec.pushdown.weights;

import de.breakpointsec.pushdown.weights.Semiring;
import java.util.HashSet;
import java.util.Set;

public class DataFlowPathSemiring<Statement>
extends Semiring<String> {
    private static DataFlowPathSemiring one;
    private static DataFlowPathSemiring zero;
    private Set<Statement> allStatements;
    private Set<Statement> lastStatements;
    private String rep;

    private DataFlowPathSemiring(String rep) {
        this.rep = rep;
    }

    private DataFlowPathSemiring(Set<Statement> allStatement, Set<Statement> lastStatements) {
        this.allStatements = allStatement;
        this.lastStatements = lastStatements;
    }

    public DataFlowPathSemiring(Statement relevantStatement) {
        this.allStatements = new HashSet<Statement>();
        this.lastStatements = new HashSet<Statement>();
        this.allStatements.add(relevantStatement);
        this.lastStatements.add(relevantStatement);
    }

    @Override
    public Semiring extendWith(Semiring o) {
        if (!(o instanceof DataFlowPathSemiring)) {
            throw new RuntimeException("Cannot extend to different types of weight!");
        }
        DataFlowPathSemiring other = (DataFlowPathSemiring)o;
        if (other.equals(DataFlowPathSemiring.one())) {
            return this;
        }
        if (this.equals(DataFlowPathSemiring.one())) {
            return other;
        }
        if (other.equals(DataFlowPathSemiring.zero()) || this.equals(DataFlowPathSemiring.zero())) {
            return DataFlowPathSemiring.zero();
        }
        HashSet<Statement> newAllStatements = new HashSet<Statement>();
        newAllStatements.addAll(this.allStatements);
        newAllStatements.addAll(other.allStatements);
        return new DataFlowPathSemiring(newAllStatements, other.lastStatements);
    }

    @Override
    public Semiring combineWith(Semiring other) {
        return this.extendWith(other);
    }

    @Override
    public String value() {
        return this.rep;
    }

    public static DataFlowPathSemiring one() {
        if (one == null) {
            one = new DataFlowPathSemiring("<ONE>");
        }
        return one;
    }

    public static DataFlowPathSemiring zero() {
        if (zero == null) {
            zero = new DataFlowPathSemiring("<ZERO>");
        }
        return zero;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allStatements == null ? 0 : this.allStatements.hashCode());
        result = 31 * result + (this.lastStatements == null ? 0 : this.lastStatements.hashCode());
        result = 31 * result + (this.rep == null ? 0 : this.rep.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataFlowPathSemiring other = (DataFlowPathSemiring)obj;
        if (this.allStatements == null ? other.allStatements != null : !this.allStatements.equals(other.allStatements)) {
            return false;
        }
        if (this.lastStatements == null ? other.lastStatements != null : !this.lastStatements.equals(other.lastStatements)) {
            return false;
        }
        return !(this.rep == null ? other.rep != null : !this.rep.equals(other.rep));
    }

    public String toString() {
        return "\nLast relevant: " + this.lastStatements + "\nAll statements: " + this.allStatements;
    }
}

