/*
 * Decompiled with CFR 0.152.
 */
package de.breakpointsec.pushdown.fsm;

import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import de.breakpointsec.pushdown.IllegalTransitionException;
import de.breakpointsec.pushdown.fsm.Transition;
import de.breakpointsec.pushdown.weights.Semiring;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class WeightedAutomaton<L, S, W extends Semiring> {
    private Map<Transition<L, S>, W> transitionToWeights = new HashMap<Transition<L, S>, W>();
    private Set<Transition<L, S>> transitions = new HashSet<Transition<L, S>>();
    private Set<S> finalState = new HashSet<S>();
    private final S initialState;
    protected Set<S> states = new HashSet<S>();
    private final Multimap<S, Transition<L, S>> transitionsOutOf = HashMultimap.create();
    private final Multimap<S, Transition<L, S>> transitionsInto = HashMultimap.create();
    private WeightedAutomaton<L, S, W> initialAutomaton;
    private Set<S> unbalancedStates = new HashSet<S>();
    private Map<Transition<L, S>, W> transitionsToFinalWeights = new HashMap<Transition<L, S>, W>();

    public WeightedAutomaton(S initialState) {
        this.initialState = initialState;
        this.unbalancedStates.add(initialState);
    }

    public abstract S createState(S var1, L var2);

    public abstract boolean isGeneratedState(S var1);

    public abstract L epsilon();

    public Collection<Transition<L, S>> getTransitions() {
        return Sets.newHashSet(this.transitions);
    }

    public void addTransition(Transition<L, S> trans, W weight) {
        this.transitionsOutOf.get(trans.getStart()).add(trans);
        this.transitionsInto.get(trans.getTarget()).add(trans);
        this.states.add(trans.getTarget());
        this.states.add(trans.getStart());
        boolean added = this.transitions.add(trans);
        this.transitionToWeights.put(trans, weight);
    }

    public boolean addTransition(Transition<L, S> trans) {
        return this.combineWeightForTransition(trans, this.getOne());
    }

    public S getInitialState() {
        return this.initialState;
    }

    public Set<S> getFinalState() {
        return this.finalState;
    }

    public String toString() {
        String s = "PAutomaton\n";
        s = s + "\tInitialStates:" + this.initialState + "\n";
        s = s + "\tFinalStates:" + this.finalState + "\n";
        s = s + "\tWeightToTransitions:\n\t\t";
        s = s + Joiner.on((String)"\n\t\t").join(this.transitionToWeights.entrySet());
        return s;
    }

    private String wrapIfInitialOrFinalState(S s) {
        return s.equals(this.initialState) ? "ENTRY: " + this.wrapFinalState(s) : this.wrapFinalState(s);
    }

    private String wrapFinalState(S s) {
        return this.finalState.contains(s) ? "TO: " + s + "" : s.toString();
    }

    public String toDotString() {
        return this.toDotString(new HashSet<WeightedAutomaton<L, S, W>>());
    }

    private String toDotString(Set<WeightedAutomaton<L, S, W>> visited) {
        if (!visited.add(this)) {
            return "NESTED loop: " + this.getInitialState();
        }
        String s = "digraph {\n";
        TreeSet<String> trans = new TreeSet<String>();
        for (S source : this.states) {
            Collection collection = this.transitionsOutOf.get(source);
            for (S target : this.states) {
                LinkedList<String> labels = new LinkedList<String>();
                for (Transition t : collection) {
                    if (!t.getTarget().equals(target)) continue;
                    labels.add(this.escapeQuotes(t.getString().toString()) + " W: " + this.transitionToWeights.get(t));
                }
                if (labels.isEmpty()) continue;
                String v = "\t\"" + this.escapeQuotes(this.wrapIfInitialOrFinalState(source)) + "\"";
                v = v + " -> \"" + this.escapeQuotes(this.wrapIfInitialOrFinalState(target)) + "\"";
                v = v + "[label=\"" + String.join((CharSequence)"\\n", labels) + "\"];\n";
                trans.add(v);
            }
        }
        s = s + Joiner.on((String)"").join(trans);
        s = s + "}\n";
        s = s + "Transitions: " + this.transitions.size() + "\n";
        return s;
    }

    private String escapeQuotes(String string) {
        return string.replace("\"", "");
    }

    public String toLabelGroupedDotString() {
        HashBasedTable groupedByTargetAndLabel = HashBasedTable.create();
        for (Transition<L, S> t : this.transitions) {
            HashSet<S> collection = (HashSet<S>)groupedByTargetAndLabel.get(t.getTarget(), t.getLabel());
            if (collection == null) {
                collection = new HashSet<S>();
            }
            collection.add(t.getStart());
            groupedByTargetAndLabel.put(t.getTarget(), t.getLabel(), collection);
        }
        StringBuilder s = new StringBuilder("digraph {\n");
        for (Object target : groupedByTargetAndLabel.rowKeySet()) {
            for (Object label : groupedByTargetAndLabel.columnKeySet()) {
                Collection source = (Collection)groupedByTargetAndLabel.get(target, label);
                if (source == null) continue;
                s.append("\t\"");
                s.append(Joiner.on((String)"\\n").join((Iterable)source));
                s.append("\"");
                s.append(" -> \"");
                s.append(this.wrapIfInitialOrFinalState(target));
                s.append("\"");
                s.append("[label=\"");
                s.append(label);
                s.append("\"];\n");
            }
        }
        s.append("}\n");
        s.append("Transitions: ");
        s.append(this.transitions.size());
        s.append("\n");
        return s.toString();
    }

    public Set<S> getStates() {
        return this.states;
    }

    public Set<Transition<L, S>> getEdges() {
        HashSet<Transition<L, S>> trans = new HashSet<Transition<L, S>>();
        for (Transition<L, S> tran : this.transitions) {
            if (tran.getLabel().equals(this.epsilon())) continue;
            trans.add(new Transition<L, S>(tran.getTarget(), tran.getLabel(), tran.getStart()));
        }
        return trans;
    }

    public Set<S> getNodes() {
        return this.getStates();
    }

    public void setWeightForTransition(Transition<L, S> trans, W weight) throws IllegalTransitionException {
        if (weight == null) {
            throw new IllegalArgumentException("Semiring must not be null!");
        }
        if (trans.getStart().equals(trans.getTarget()) && trans.getLabel().equals(this.epsilon())) {
            throw new IllegalTransitionException("Epsilon loop in state " + trans.getStart().toString());
        }
        this.transitionsOutOf.get(trans.getStart()).add(trans);
        this.transitionsInto.get(trans.getTarget()).add(trans);
        this.states.add(trans.getTarget());
        this.states.add(trans.getStart());
        boolean added = this.transitions.add(trans);
        this.transitionToWeights.put(trans, weight);
    }

    public boolean combineWeightForTransition(Transition<L, S> trans, W weight) {
        W newWeight;
        if (weight == null) {
            throw new IllegalArgumentException("Semiring must not be null!");
        }
        if (trans.getStart().equals(trans.getTarget()) && trans.getLabel().equals(this.epsilon())) {
            return false;
        }
        this.transitionsOutOf.get(trans.getStart()).add(trans);
        this.transitionsInto.get(trans.getTarget()).add(trans);
        this.states.add(trans.getTarget());
        this.states.add(trans.getStart());
        boolean added = this.transitions.add(trans);
        Semiring oldWeight = (Semiring)this.transitionToWeights.get(trans);
        Object object = newWeight = oldWeight == null ? weight : oldWeight.combineWith((Semiring)weight);
        if (!newWeight.equals(oldWeight)) {
            this.transitionToWeights.put(trans, newWeight);
            return true;
        }
        return added;
    }

    public W getWeightFor(Transition<L, S> trans) {
        return (W)((Semiring)this.transitionToWeights.get(trans));
    }

    public void addFinalState(S state) {
        this.finalState.add(state);
    }

    public abstract W getZero();

    public abstract W getOne();

    public Collection<Transition<L, S>> getTransitionsOutOf(S s) {
        return this.transitionsOutOf.get(s);
    }

    public Collection<Transition<L, S>> getTransitionsInto(S s) {
        return this.transitionsInto.get(s);
    }

    public Collection<S> getTransitionTargetsIgnoringEpsilon(S start, L label) {
        Object t;
        HashSet results = new HashSet();
        LinkedList worklist = new LinkedList(this.transitionsOutOf.get(start));
        while (!worklist.isEmpty()) {
            t = (Transition)worklist.pop();
            if (((Transition)t).getLabel().equals(this.epsilon())) {
                worklist.addAll(this.transitionsOutOf.get(((Transition)t).getTarget()));
                continue;
            }
            if (!((Transition)t).getLabel().equals(label)) continue;
            results.add(((Transition)t).getTarget());
        }
        if (results.isEmpty()) {
            return results;
        }
        for (Object s : results) {
            worklist.addAll(this.transitionsOutOf.get(s));
        }
        while (!worklist.isEmpty()) {
            t = (Transition)worklist.pop();
            if (!((Transition)t).getLabel().equals(this.epsilon())) continue;
            results.add(((Transition)t).getTarget());
            worklist.addAll(this.transitionsOutOf.get(((Transition)t).getTarget()));
        }
        return results;
    }

    public void addUnbalancedState(S state) {
        this.unbalancedStates.add(state);
    }

    public Map<Transition<L, S>, W> getTransitionsToFinalWeights() {
        for (S s : this.unbalancedStates) {
            this.updateFinalWeights(s, this.getOne());
        }
        return this.transitionsToFinalWeights;
    }

    private void updateFinalWeights(S s, W weight) {
        for (Transition t : Lists.newArrayList((Iterable)this.transitionsInto.get(s))) {
            Semiring w = (Semiring)this.transitionToWeights.get(t);
            Semiring newWeight = ((Semiring)weight).extendWith(w);
            Semiring weightAtTarget = (Semiring)this.transitionsToFinalWeights.get(t);
            Semiring newVal = weightAtTarget == null ? newWeight : weightAtTarget.combineWith(newWeight);
            this.transitionsToFinalWeights.put(t, newVal);
            if (!this.isGeneratedState(t.getStart())) continue;
            this.updateFinalWeights(t.getStart(), newVal);
        }
    }

    public boolean containsLoop() {
        HashSet visited = new HashSet();
        LinkedList<Object> worklist = new LinkedList<Object>();
        worklist.add(this.initialState);
        while (!worklist.isEmpty()) {
            Object pop = worklist.pop();
            visited.add(pop);
            Collection inTrans = this.transitionsInto.get(pop);
            for (Transition t : inTrans) {
                if (t.getLabel().equals(this.epsilon()) || !this.isGeneratedState(t.getStart())) continue;
                if (visited.contains(t.getStart())) {
                    return true;
                }
                worklist.add(t.getStart());
            }
        }
        return false;
    }

    public Set<L> getLongestPath() {
        LinkedList<Object> worklist = new LinkedList<Object>();
        worklist.add(this.initialState);
        HashMap pathReachingD = new HashMap();
        while (!worklist.isEmpty()) {
            Object pop = worklist.pop();
            Set<L> atCurr = this.getOrCreate(pathReachingD, pop);
            Collection inTrans = this.transitionsInto.get(pop);
            for (Transition t : inTrans) {
                boolean addAll;
                Object next;
                if (t.getLabel().equals(this.epsilon()) || !this.isGeneratedState(next = t.getStart()) || next.equals(pop)) continue;
                Set<L> atNext = this.getOrCreate(pathReachingD, next);
                HashSet newAtCurr = Sets.newHashSet(atCurr);
                if (!newAtCurr.add(t.getLabel()) || !(addAll = atNext.addAll(newAtCurr))) continue;
                worklist.add(next);
            }
        }
        Set longest = new HashSet();
        for (Set l : pathReachingD.values()) {
            if (longest.size() >= l.size()) continue;
            longest = l;
        }
        return longest;
    }

    private Set<L> getOrCreate(Map<S, Set<L>> pathReachingD, S pop) {
        Set<L> collection = pathReachingD.get(pop);
        if (collection == null) {
            collection = new HashSet<L>();
            pathReachingD.put(pop, collection);
        }
        return collection;
    }
}

