/*
 * Decompiled with CFR 0.152.
 */
package de.breakpointsec.pushdown;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import de.breakpointsec.pushdown.IllegalTransitionException;
import de.breakpointsec.pushdown.fsm.Transition;
import de.breakpointsec.pushdown.fsm.WeightedAutomaton;
import de.breakpointsec.pushdown.rules.NormalRule;
import de.breakpointsec.pushdown.rules.PopRule;
import de.breakpointsec.pushdown.rules.PushRule;
import de.breakpointsec.pushdown.rules.Rule;
import de.breakpointsec.pushdown.weights.Semiring;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class WPDS<L, S, W extends Semiring> {
    protected final Set<PushRule<L, S, W>> pushRules = Sets.newHashSet();
    protected final Set<PopRule<L, S, W>> popRules = Sets.newHashSet();
    protected Set<S> states = Sets.newHashSet();
    protected final Set<NormalRule<L, S, W>> normalRules = Sets.newHashSet();
    private final Multimap<S, Transition<L, S>> transitionsInto = HashMultimap.create();

    public boolean addRule(Rule<L, S, W> rule) {
        return this.addRuleInternal(rule);
    }

    private boolean addRuleInternal(Rule<L, S, W> rule) {
        if (rule instanceof PushRule) {
            return this.pushRules.add((PushRule)rule);
        }
        if (rule instanceof PopRule) {
            return this.popRules.add((PopRule)rule);
        }
        if (rule instanceof NormalRule) {
            return this.normalRules.add((NormalRule)rule);
        }
        throw new RuntimeException("Try to add a rule of wrong type");
    }

    public Set<NormalRule<L, S, W>> getNormalRules() {
        return this.normalRules;
    }

    public Set<PopRule<L, S, W>> getPopRules() {
        return this.popRules;
    }

    public Set<PushRule<L, S, W>> getPushRules() {
        return this.pushRules;
    }

    public Set<Rule<L, S, W>> getAllRules() {
        HashSet rules = Sets.newHashSet();
        rules.addAll(this.normalRules);
        rules.addAll(this.popRules);
        rules.addAll(this.pushRules);
        return rules;
    }

    @Deprecated
    public Set<Rule<L, S, W>> getRulesStarting(S start, L string) {
        HashSet<Rule<L, S, W>> result = new HashSet<Rule<L, S, W>>();
        this.getRulesStartingWithinSet(start, string, this.popRules, result);
        this.getRulesStartingWithinSet(start, string, this.normalRules, result);
        this.getRulesStartingWithinSet(start, string, this.pushRules, result);
        return result;
    }

    @Deprecated
    private void getRulesStartingWithinSet(S start, L string, Set<? extends Rule<L, S, W>> rules, Set<Rule<L, S, W>> res) {
        for (Rule<L, S, W> r : rules) {
            if (!r.getS1().equals(start) || !r.getL1().equals(string)) continue;
            res.add(r);
        }
    }

    public Set<NormalRule<L, S, W>> getNormalRulesEnding(S start, L string) {
        Set<NormalRule<L, S, W>> allRules = this.getNormalRules();
        HashSet<NormalRule<L, S, W>> result = new HashSet<NormalRule<L, S, W>>();
        for (NormalRule<L, S, W> r : allRules) {
            if (!r.getS2().equals(start) || !r.getL2().equals(string)) continue;
            result.add(r);
        }
        return result;
    }

    public Set<PushRule<L, S, W>> getPushRulesEnding(S start, L string) {
        Set<PushRule<L, S, W>> allRules = this.getPushRules();
        HashSet<PushRule<L, S, W>> result = new HashSet<PushRule<L, S, W>>();
        for (PushRule<L, S, W> r : allRules) {
            if (!r.getS2().equals(start) || !r.getL2().equals(string)) continue;
            result.add(r);
        }
        return result;
    }

    @Deprecated
    public Set<S> getStates() {
        HashSet states = Sets.newHashSet();
        for (Rule<L, S, W> r : this.getAllRules()) {
            states.add(r.getS1());
            states.add(r.getS2());
        }
        return states;
    }

    protected boolean updatePostStar(Transition<L, S> t, W w, Rule rule, WeightedAutomaton<L, S, W> fa, LinkedList<Transition<L, S>> worklist) throws IllegalTransitionException {
        boolean changed;
        W oldWeight;
        if (!fa.getTransitions().contains(t)) {
            fa.addTransition(t, null);
        }
        W newWeight = (oldWeight = fa.getWeightFor(t)) == null ? w : ((Semiring)oldWeight).combineWith((Semiring)w);
        boolean bl = changed = !newWeight.equals(oldWeight);
        if (changed) {
            fa.setWeightForTransition(t, newWeight);
            worklist.add(t);
        }
        return changed;
    }

    public void poststar(WeightedAutomaton<L, S, W> fa) throws IllegalTransitionException {
        Object irState;
        HashMap generatedStates = new HashMap();
        for (PushRule<L, S, W> rule : this.getPushRules()) {
            Object p = rule.getS2();
            Object Location2 = rule.getL2();
            irState = fa.createState(p, Location2);
            L transitionLabel = rule.getCallSite();
            generatedStates.put(rule, irState);
        }
        LinkedList worklist = Lists.newLinkedList(fa.getTransitions());
        while (!worklist.isEmpty()) {
            Semiring newWeight;
            Transition newTrans;
            Transition t = (Transition)worklist.pop();
            if (t.getLabel().equals(this.epsilon())) {
                for (Transition transition : fa.getTransitionsOutOf(t.getTarget())) {
                    newTrans = new Transition(t.getStart(), transition.getLabel(), transition.getTarget());
                    newWeight = ((Semiring)fa.getWeightFor(transition)).extendWith((Semiring)fa.getWeightFor(t));
                    this.updatePostStar(newTrans, newWeight, null, fa, worklist);
                }
                continue;
            }
            for (PopRule popRule : this.getPopRules()) {
                if (!popRule.getS1().equals(t.getStart()) || !popRule.getL1().equals(t.getLabel())) continue;
                newTrans = new Transition(popRule.getS2(), this.epsilon(), t.getTarget());
                newWeight = ((Semiring)fa.getWeightFor(t)).extendWith((Semiring)popRule.getWeight());
                this.updatePostStar(newTrans, newWeight, popRule, fa, worklist);
            }
            for (NormalRule normalRule : this.getNormalRules()) {
                if (!normalRule.getS1().equals(t.getStart()) || !normalRule.getL1().equals(t.getLabel())) continue;
                newTrans = new Transition(normalRule.getS2(), normalRule.getL2(), t.getTarget());
                newWeight = ((Semiring)fa.getWeightFor(t)).extendWith((Semiring)normalRule.getWeight());
                this.updatePostStar(newTrans, newWeight, normalRule, fa, worklist);
            }
            for (PushRule pushRule : this.getPushRules()) {
                Semiring newWeight2;
                if (!pushRule.getS1().equals(t.getStart()) || !pushRule.getL1().equals(t.getLabel())) continue;
                irState = generatedStates.get(pushRule);
                if (irState == null) {
                    System.out.println("UNEXPECTED: No generated state found for rule " + pushRule.toString());
                }
                Transition newTrans2 = new Transition(pushRule.getS2(), pushRule.getL2(), irState);
                this.updatePostStar(newTrans2, fa.getOne(), pushRule, fa, worklist);
                Transition newTrans22 = new Transition(irState, pushRule.getCallSite(), t.getTarget());
                boolean changed = this.updatePostStar(newTrans22, newWeight2 = ((Semiring)fa.getWeightFor(t)).extendWith((Semiring)pushRule.getWeight()), pushRule, fa, worklist);
                if (!changed) continue;
                Set tPrimes = fa.getTransitionsInto(irState).stream().filter(trans -> trans.getLabel().equals(fa.epsilon()) && trans.getTarget().equals(irState)).collect(Collectors.toSet());
                for (Transition tPrime : tPrimes) {
                    this.updatePostStar(new Transition(tPrime.getStart(), pushRule.getCallSite(), t.getTarget()), newWeight2.extendWith((Semiring)fa.getWeightFor(tPrime)), pushRule, fa, worklist);
                }
            }
        }
    }

    public WeightedAutomaton<L, S, W> prestar(WeightedAutomaton<L, S, W> fa) throws IllegalTransitionException {
        LinkedList worklist = Lists.newLinkedList(fa.getTransitions());
        for (Transition transition : Sets.newHashSet(fa.getTransitions())) {
            W one = fa.getOne();
            fa.combineWeightForTransition(transition, one);
        }
        for (PopRule popRule : this.getPopRules()) {
            this.updatePrestar(worklist, new Transition(popRule.getS1(), popRule.getL1(), popRule.getS2()), (Semiring)popRule.getWeight(), fa);
        }
        while (!worklist.isEmpty()) {
            Transition t = (Transition)worklist.pop();
            Set set = this.getNormalRulesEnding(t.getStart(), t.getLabel());
            for (NormalRule normalRule : set) {
                this.updatePrestar(worklist, new Transition(normalRule.getS1(), normalRule.getL1(), t.getTarget()), ((Semiring)normalRule.getWeight()).extendWith((Semiring)fa.getWeightFor(t)), fa);
            }
            for (PushRule pushRule : this.getPushRules()) {
                if (!pushRule.getS2().equals(t.getStart()) || !pushRule.getL2().equals(t.getLabel())) continue;
                for (Transition tdash : Sets.newHashSet(fa.getTransitionsOutOf(t.getTarget()))) {
                    if (!tdash.getLabel().equals(pushRule.getCallSite())) continue;
                    this.updatePrestar(worklist, new Transition(pushRule.getS1(), pushRule.getL1(), tdash.getTarget()), ((Semiring)pushRule.getWeight()).extendWith((Semiring)fa.getWeightFor(t)).extendWith((Semiring)fa.getWeightFor(tdash)), fa);
                }
            }
            for (PushRule pushRule : this.getPushRules()) {
                if (!pushRule.getL2().equals(t.getLabel())) continue;
                for (Transition tdash : Sets.newHashSet(fa.getTransitionsOutOf(pushRule.getS2()))) {
                    if (!tdash.getLabel().equals(pushRule.getCallSite()) || !tdash.getTarget().equals(t.getStart())) continue;
                    this.updatePrestar(worklist, new Transition(pushRule.getS1(), pushRule.getL1(), t.getTarget()), ((Semiring)pushRule.getWeight()).extendWith((Semiring)fa.getWeightFor(tdash)).extendWith((Semiring)fa.getWeightFor(t)), fa);
                }
            }
        }
        return fa;
    }

    protected void updatePrestar(LinkedList<Transition<L, S>> worklist, Transition<L, S> t, W w, WeightedAutomaton<L, S, W> fa) throws IllegalTransitionException {
        boolean changed;
        W oldWeight;
        if (!fa.getTransitions().contains(t)) {
            fa.addTransition(t, null);
        }
        W newWeight = (oldWeight = fa.getWeightFor(t)) == null ? w : ((Semiring)oldWeight).combineWith((Semiring)w);
        boolean bl = changed = !newWeight.equals(oldWeight);
        if (changed) {
            fa.setWeightForTransition(t, newWeight);
            worklist.add(t);
        }
    }

    public String toString() {
        String s = "WPDS (#Rules: " + this.getAllRules().size() + ")\n";
        s = s + "\tNormalRules:\n\t\t";
        s = s + Joiner.on((String)"\n\t\t").join(this.normalRules);
        s = s + "\n";
        s = s + "\tPopRules:\n\t\t";
        s = s + Joiner.on((String)"\n\t\t").join(this.popRules);
        s = s + "\n";
        s = s + "\tPushRules:\n\t\t";
        s = s + Joiner.on((String)"\n\t\t").join(this.pushRules);
        return s;
    }

    public abstract L epsilon();
}

