/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.grammar;

import de.bottlecaps.markup.blitz.codepoints.Codepoint;
import de.bottlecaps.markup.blitz.codepoints.RangeSet;
import de.bottlecaps.markup.blitz.codepoints.UnicodeCategory;
import de.bottlecaps.markup.blitz.grammar.ClassMember;
import de.bottlecaps.markup.blitz.grammar.Member;
import de.bottlecaps.markup.blitz.grammar.RangeMember;
import de.bottlecaps.markup.blitz.grammar.StringMember;
import de.bottlecaps.markup.blitz.grammar.Term;
import de.bottlecaps.markup.blitz.transform.Visitor;
import java.util.List;
import java.util.stream.Collectors;

public class Charset
extends Term {
    public static final Charset END = new Charset(true, RangeSet.EOF);
    private final boolean deleted;
    private final RangeSet rangeSet;
    private final boolean exclusion;
    private final List<Member> members;

    private Charset(boolean deleted, RangeSet rangeSet, boolean exclusion, List<Member> members) {
        this.deleted = deleted;
        this.exclusion = exclusion;
        this.members = members;
        this.rangeSet = rangeSet != null ? rangeSet : Charset.toRangeSet(exclusion, members);
    }

    public Charset(boolean deleted, boolean exclusion, List<Member> members) {
        this(deleted, null, exclusion, members);
    }

    public Charset(boolean deleted, RangeSet rangeSet) {
        this(deleted, rangeSet, false, null);
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public RangeSet getRangeSet() {
        return this.rangeSet;
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    public Charset copy() {
        return new Charset(this.deleted, this.rangeSet, this.exclusion, this.members);
    }

    private static RangeSet toRangeSet(boolean exclusion, List<Member> members) {
        RangeSet.Builder builder = RangeSet.builder();
        for (Member member : members) {
            if (member instanceof StringMember) {
                StringMember m = (StringMember)member;
                String value = m.getValue();
                if (m.isHex()) {
                    int codepoint = Codepoint.of(value.substring(1));
                    builder.add(codepoint);
                    continue;
                }
                value.codePoints().forEach(builder::add);
                continue;
            }
            if (member instanceof RangeMember) {
                builder.add(((RangeMember)member).getRange());
                continue;
            }
            if (member instanceof ClassMember) {
                UnicodeCategory.forCode(((ClassMember)member).getValue()).forEach(builder::add);
                continue;
            }
            throw new IllegalStateException();
        }
        return exclusion ? UnicodeCategory.ALPHABET.minus(builder.build()) : builder.build();
    }

    public String toString() {
        String prefix = (this.deleted ? "-" : "") + (this.exclusion ? "~" : "");
        return prefix + (this.equals(END) && this.grammar != null && this.grammar.getAdditionalNames() != null ? this.grammar.getAdditionalNames().get(END)[0] : (this.members != null ? this.members.stream().map(Object::toString).collect(Collectors.joining("; ", "[", "]")) : this.rangeSet.toString()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.deleted ? 1231 : 1237);
        result = 31 * result + (this.rangeSet == null ? 0 : this.rangeSet.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Charset)) {
            return false;
        }
        Charset other = (Charset)obj;
        if (this.deleted != other.deleted) {
            return false;
        }
        return !(this.rangeSet == null ? other.rangeSet != null : !this.rangeSet.equals(other.rangeSet));
    }
}

