/*
 * Decompiled with CFR 0.152.
 */
package de.boreddevblog.license;

import de.boreddevblog.license.InternalMapper;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class Mapper {
    private static final Set<InternalMapper<?, ?>> mappers = new HashSet();

    public static void add(InternalMapper<?, ?> mapper) {
        mappers.add(mapper);
    }

    public static boolean canMap(Class<?> from, Class<?> to) {
        return mappers.stream().filter(m -> m.getFrom() == from && m.getTo() == to).findAny().isPresent();
    }

    public static <S, T> T mapToClass(S o, Class<? extends T> target) {
        return (T)mappers.stream().filter(m -> m.getFrom() == o.getClass() && m.getTo() == target).map(m -> m).findAny().get().getMapper().apply(o);
    }

    static {
        Mapper.add(new InternalMapper<String, LocalDateTime>(String.class, LocalDateTime.class, str -> LocalDateTime.parse(str, DateTimeFormatter.ISO_DATE_TIME)));
        Mapper.add(new InternalMapper<Object[], String[]>(Object[].class, String[].class, os -> (String[])Arrays.stream(os).map(o -> o.toString()).toArray(String[]::new)));
    }
}

