/*
 * Decompiled with CFR 0.152.
 */
package de.boreddevblog.license;

import de.boreddevblog.license.DescriptorAlreadyExistsException;
import de.boreddevblog.license.DescriptorTypeMismatchException;
import de.boreddevblog.license.KeyPairProvider;
import de.boreddevblog.license.LicensePropertyDescriptor;
import de.boreddevblog.license.Mapper;
import de.boreddevblog.license.NoDescriptorException;
import de.boreddevblog.license.ReservedNameException;
import de.boreddevblog.license.VerificationException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.NonNull;

public abstract class License {
    private static final String SIGNATURE_ALGORITHM = "SHA512withRSA";
    public static final String RESERVED_NAME_KEY = "key";
    private static final String[] RESERVED_NAMES = new String[]{"key"};
    private static final Set<String> reservedNames = new HashSet<String>(Arrays.asList(RESERVED_NAMES));
    private final Map<String, LicensePropertyDescriptor> propertyDescriptors = new HashMap<String, LicensePropertyDescriptor>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Supplier<KeyPairProvider> keyPairProviderSupplier = () -> {
        KeyPairProvider keyPairProvider = this.getKeyPairProvider();
        if (keyPairProvider == null) {
            throw new NullPointerException("No KeyPairProvider defined");
        }
        if (keyPairProvider.getKeyPair() == null) {
            throw new NullPointerException("KeyPairProvider does not provide a KeyPair");
        }
        return keyPairProvider;
    };

    public License() {
        this.addPropertyDescriptor0(new LicensePropertyDescriptor(RESERVED_NAME_KEY, String.class));
    }

    protected abstract KeyPairProvider getKeyPairProvider();

    protected final void addPropertyDescriptor(@NonNull LicensePropertyDescriptor desc) {
        if (desc == null) {
            throw new NullPointerException("desc");
        }
        this.ensureNotReserved(desc.getPropertyName());
        this.addPropertyDescriptor0(desc);
    }

    private void addPropertyDescriptor0(@NonNull LicensePropertyDescriptor desc) {
        if (desc == null) {
            throw new NullPointerException("desc");
        }
        if (this.propertyDescriptors.get(desc.getPropertyName()) != null) {
            throw new DescriptorAlreadyExistsException("A descriptor for property '" + desc.getPropertyName() + "' already exists");
        }
        this.propertyDescriptors.put(desc.getPropertyName(), desc);
    }

    public final void addProperty(@NonNull String key, Object value) {
        if (key == null) {
            throw new NullPointerException(RESERVED_NAME_KEY);
        }
        this.ensureNotReserved(key);
        this.addProperty0(key, value);
    }

    protected final void setKey(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException(RESERVED_NAME_KEY);
        }
        this.addProperty0(RESERVED_NAME_KEY, key);
    }

    private final void addProperty0(@NonNull String key, Object value) {
        if (key == null) {
            throw new NullPointerException(RESERVED_NAME_KEY);
        }
        LicensePropertyDescriptor desc = this.propertyDescriptors.get(key);
        if (desc == null) {
            throw new NoDescriptorException("No descriptor for property " + key);
        }
        if (!desc.getType().isAssignableFrom(value.getClass())) {
            if (!Mapper.canMap(value.getClass(), desc.getType())) {
                throw new DescriptorTypeMismatchException("'" + key + "' is of type " + value.getClass().getName() + ", expected " + desc.getType().getName());
            }
            this.properties.put(key, Mapper.mapToClass(value, desc.getType()));
        } else {
            this.properties.put(key, value);
        }
    }

    public abstract String toString();

    public abstract void load(@NonNull File var1) throws IOException;

    public final void sign() throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        this.properties.keySet().stream().map(this.propertyDescriptors::get).filter(LicensePropertyDescriptor::isDeprecated).map(LicensePropertyDescriptor::getPropertyName).forEach(name -> System.err.println("[WARN] '" + name + "' is deprecated and should not be used. It will be removed in a future build."));
        KeyPairProvider keyPairProvider = this.keyPairProviderSupplier.get();
        KeyPair keyPair = keyPairProvider.getKeyPair();
        if (keyPair.getPrivate() == null) {
            throw new NullPointerException("KeyPairProvider does not provide a private key to sign the license");
        }
        Signature sig = Signature.getInstance(SIGNATURE_ALGORITHM);
        sig.initSign(keyPair.getPrivate());
        sig.update(this.getSignableString().getBytes(Charset.forName("UTF-8")));
        this.setKey(Base64.getEncoder().encodeToString(sig.sign()));
    }

    private String getSignableString() {
        List<Map.Entry<String, Object>> sorted = this.getPropertiesSorted();
        StringJoiner sj = new StringJoiner("#");
        sorted.forEach(e -> {
            if (e.getValue().getClass().isArray()) {
                sj.add((String)e.getKey() + "=" + Arrays.deepToString((Object[])e.getValue()));
            } else {
                sj.add((String)e.getKey() + "=" + e.getValue());
            }
        });
        return sj.toString();
    }

    private List<Map.Entry<String, Object>> getPropertiesSorted() {
        return this.properties.entrySet().stream().filter(e -> e.getKey() != RESERVED_NAME_KEY).sorted((fst, snd) -> ((String)fst.getKey()).compareTo((String)snd.getKey())).collect(Collectors.toList());
    }

    public final void verify() throws VerificationException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Set required = this.propertyDescriptors.values().stream().filter(desc -> desc.isRequired() || desc.getRequiredIf() != null && desc.getRequiredIf().test(this)).map(LicensePropertyDescriptor::getPropertyName).collect(Collectors.toSet());
        this.properties.keySet().forEach(required::remove);
        if (!required.isEmpty()) {
            throw new VerificationException("Missing required properties: " + required);
        }
        KeyPairProvider keyPairProvider = this.keyPairProviderSupplier.get();
        KeyPair keyPair = keyPairProvider.getKeyPair();
        if (keyPair.getPublic() == null) {
            throw new NullPointerException("KeyPairProvider does not provide a public key to verify the license");
        }
        String key = (String)this.properties.get(RESERVED_NAME_KEY);
        if (key == null) {
            throw new VerificationException("No key is present. The license has not been signed yet.");
        }
        Signature sig = Signature.getInstance(SIGNATURE_ALGORITHM);
        sig.initVerify(keyPair.getPublic());
        sig.update(this.getSignableString().getBytes(Charset.forName("UTF-8")));
        boolean isValid = sig.verify(Base64.getDecoder().decode(key));
        if (!isValid) {
            throw new VerificationException("License key is invalid");
        }
    }

    public void saveTo(@NonNull OutputStream destination) throws IOException {
        if (destination == null) {
            throw new NullPointerException("destination");
        }
        destination.write(this.toString().getBytes(Charset.forName("UTF-8")));
    }

    private final void ensureNotReserved(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException(RESERVED_NAME_KEY);
        }
        if (reservedNames.contains(key)) {
            throw new ReservedNameException(key + " is a reserved property name");
        }
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Map<String, LicensePropertyDescriptor> getPropertyDescriptors() {
        return Collections.unmodifiableMap(this.propertyDescriptors);
    }

    public <T> T get(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException(RESERVED_NAME_KEY);
        }
        return (T)this.properties.get(key);
    }
}

