/**
 * 
 */
package de.boreddevblog.license;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * @author Tim Satke
 *
 */
public class Mapper {

	private static final Set<InternalMapper<?, ?>> mappers = new HashSet<>();

	static {
		add(new InternalMapper<String, LocalDateTime>(String.class, LocalDateTime.class, str -> {
			return LocalDateTime.parse(str, DateTimeFormatter.ISO_DATE_TIME);
		}));
		add(new InternalMapper<Object[], String[]>(Object[].class, String[].class, os -> {
			return Arrays.stream(os).map(o -> o.toString()).toArray(String[]::new);
		}));
	}

	public static void add(InternalMapper<?, ?> mapper) {
		mappers.add(mapper);
	}

	public static boolean canMap(Class<?> from, Class<?> to) {
		return mappers.stream().filter(m -> m.getFrom() == from && m.getTo() == to).findAny().isPresent();
	}

	@SuppressWarnings("unchecked")
	public static <S, T> T mapToClass(S o, Class<? extends T> target) {
		return (T) mappers.stream().filter(m -> m.getFrom() == o.getClass() && m.getTo() == target)
				.map(m -> (InternalMapper<S, T>) m).findAny().get().getMapper().apply(o);
	}
}
