/**
 * 
 */
package de.boreddevblog.license;

import java.util.function.Predicate;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.RequiredArgsConstructor;

/**
 * @author Tim Satke
 *
 */
@Data
@Builder
@AllArgsConstructor
@RequiredArgsConstructor
public class LicensePropertyDescriptor {

	private final String propertyName;
	private final Class<?> type;

	@Builder.Default
	private boolean deprecated = false;
	@Builder.Default
	private boolean required = false;
	@Builder.Default
	private Predicate<License> requiredIf = null;

}
