/*
 * Decompiled with CFR 0.152.
 */
package de.bmiag.tapir.variant.annotation.variant;

import com.google.common.collect.Iterables;
import de.bmiag.tapir.variant.annotation.variant.Variant;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.CompilationStrategy;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

public class VariantProcessor
extends AbstractClassProcessor {
    public void doTransform(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        this.addVariantInterface(annotatedClass, context);
        this.addConfigurationAnnotation(annotatedClass, context);
        this.addPropertyAnnotation(annotatedClass, context);
        this.addNameField(annotatedClass, context);
        this.addVariantBean(annotatedClass, context);
        this.addFeatureBeanMethods(annotatedClass, context);
        this.removeVariantAnnotation(annotatedClass, context);
    }

    private void addVariantInterface(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        Type variantInterfaceType = context.findTypeGlobally(de.bmiag.tapir.variant.Variant.class);
        Iterable iterable = annotatedClass.getImplementedInterfaces();
        TypeReference typeReference = context.newTypeReference(variantInterfaceType, new TypeReference[0]);
        Iterable iterable2 = Iterables.concat((Iterable)iterable, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{typeReference})));
        annotatedClass.setImplementedInterfaces(iterable2);
    }

    private AnnotationReference addConfigurationAnnotation(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        return annotatedClass.addAnnotation(context.newAnnotationReference(Configuration.class));
    }

    private AnnotationReference addPropertyAnnotation(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        AnnotationReference annotationReference = null;
        String variantName = this.getVariantName(annotatedClass, context);
        Procedures.Procedure1 procedure1 = annotationReferenceBuildContext -> {
            annotationReferenceBuildContext.setStringValue("name", new String[]{"variant"});
            annotationReferenceBuildContext.setStringValue("havingValue", new String[]{variantName});
        };
        AnnotationReference propertyAnnotationRef = context.newAnnotationReference(ConditionalOnProperty.class, procedure1);
        annotationReference = annotatedClass.addAnnotation(propertyAnnotationRef);
        return annotationReference;
    }

    private String getVariantName(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        String string = null;
        AnnotationReference variantAnnotation = this.getVariantAnnotation(annotatedClass, context);
        String name = variantAnnotation.getStringValue("name");
        boolean bl = StringExtensions.isNullOrEmpty((String)name);
        if (bl) {
            name = annotatedClass.getSimpleName();
        }
        string = name;
        return string;
    }

    private AnnotationReference getVariantAnnotation(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        return annotatedClass.findAnnotation(context.findTypeGlobally(Variant.class));
    }

    private MutableFieldDeclaration addNameField(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        MutableFieldDeclaration mutableFieldDeclaration = null;
        String variantName = this.getVariantName(annotatedClass, context);
        Procedures.Procedure1 procedure1 = it -> {
            it.setType(context.newTypeReference(String.class, new TypeReference[0]));
            it.setStatic(true);
            it.setFinal(true);
            it.setVisibility(Visibility.PUBLIC);
            CompilationStrategy compilationStrategy = it_1 -> {
                StringConcatenation stringConcatenation = new StringConcatenation();
                stringConcatenation.append("\"");
                stringConcatenation.append(variantName);
                stringConcatenation.append("\"");
                return stringConcatenation;
            };
            it.setInitializer(compilationStrategy);
        };
        mutableFieldDeclaration = annotatedClass.addField("NAME", procedure1);
        return mutableFieldDeclaration;
    }

    private MutableMethodDeclaration addVariantBean(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        Procedures.Procedure1 procedure1 = it -> {
            it.addAnnotation(context.newAnnotationReference(Bean.class));
            it.setReturnType(context.newTypeReference(String.class, new TypeReference[0]));
            CompilationStrategy compilationStrategy = it_1 -> {
                StringConcatenation stringConcatenation = new StringConcatenation();
                stringConcatenation.append("return ");
                String string = annotatedClass.getSimpleName();
                stringConcatenation.append(string);
                stringConcatenation.append(".NAME;");
                stringConcatenation.newLineIfNotEmpty();
                return stringConcatenation;
            };
            it.setBody(compilationStrategy);
        };
        return annotatedClass.addMethod("variant", procedure1);
    }

    private void addFeatureBeanMethods(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        AnnotationReference variantAnnotation = this.getVariantAnnotation(annotatedClass, context);
        TypeReference[] features = variantAnnotation.getClassArrayValue("features");
        Consumer<TypeReference> consumer = featureTypeRef -> {
            Procedures.Procedure1 procedure1 = it -> {
                it.addAnnotation(context.newAnnotationReference(Bean.class));
                Procedures.Procedure1 procedure1 = it_1 -> {
                    String string = featureTypeRef.getType().getQualifiedName();
                    String string2 = string + ".active";
                    it_1.setStringValue("name", new String[]{string2});
                    it_1.setStringValue("havingValue", new String[]{"true"});
                    it_1.setBooleanValue("matchIfMissing", new boolean[]{true});
                };
                it.addAnnotation(context.newAnnotationReference(ConditionalOnProperty.class, procedure1));
                it.setReturnType(featureTypeRef);
                CompilationStrategy compilationStrategy = it_1 -> {
                    StringConcatenation stringConcatenation = new StringConcatenation();
                    stringConcatenation.append("return new ");
                    String string = it_1.toJavaCode(featureTypeRef);
                    stringConcatenation.append(string);
                    stringConcatenation.append("();");
                    stringConcatenation.newLineIfNotEmpty();
                    return stringConcatenation;
                };
                it.setBody(compilationStrategy);
            };
            annotatedClass.addMethod(featureTypeRef.getSimpleName().toLowerCase(), procedure1);
        };
        ((List)Conversions.doWrapArray((Object)features)).forEach(consumer);
    }

    private boolean removeVariantAnnotation(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        boolean bl = false;
        AnnotationReference variantAnnotation = this.getVariantAnnotation(annotatedClass, context);
        bl = annotatedClass.removeAnnotation(variantAnnotation);
        return bl;
    }
}

