/*
 * Decompiled with CFR 0.152.
 */
package de.bmiag.tapir.variant.filter;

import com.google.common.collect.Iterables;
import de.bmiag.tapir.execution.model.Parameterized;
import de.bmiag.tapir.execution.model.TestClass;
import de.bmiag.tapir.execution.model.TestStep;
import de.bmiag.tapir.execution.model.TestSuite;
import de.bmiag.tapir.execution.plan.ExecutionFilter;
import de.bmiag.tapir.variant.data.FeatureBased;
import de.bmiag.tapir.variant.feature.expression.ActivatedFeatureExpression;
import de.bmiag.tapir.variant.feature.expression.AllOfFeatureExpression;
import de.bmiag.tapir.variant.feature.expression.AnyOfFeatureExpression;
import de.bmiag.tapir.variant.feature.expression.FeatureExpression;
import de.bmiag.tapir.variant.feature.expression.NotFeatureExpression;
import de.bmiag.tapir.variant.service.FeatureCheckService;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="tapirFeatureBasedParameterFilter")
public class FeatureBasedParameterFilter
implements ExecutionFilter {
    @Autowired
    @Extension
    private FeatureCheckService featureCheckService;

    public boolean shouldFilterClass(TestClass testClass, Object testInstance) {
        return this.shouldFilter((Parameterized)testClass);
    }

    public boolean shouldFilterStep(TestStep testStep, Object testInstance) {
        return this.shouldFilter((Parameterized)testStep);
    }

    public boolean shouldFilterSuite(TestSuite testSuite, Object testInstance) {
        return false;
    }

    public boolean shouldFilter(Parameterized parameterized) {
        Functions.Function1 _function = it -> it.getValue();
        Functions.Function1 _function_1 = parameterValue -> {
            Function<FeatureExpression, Boolean> _function_2 = it -> this.evaluate((FeatureExpression)it);
            Boolean _orElse = parameterValue.getActivateByFeatureExpression().map(_function_2).orElse(true);
            return _orElse == false;
        };
        return IterableExtensions.exists((Iterable)Iterables.filter((Iterable)ListExtensions.map((List)parameterized.getParameters(), (Functions.Function1)_function), FeatureBased.class), (Functions.Function1)_function_1);
    }

    protected boolean _evaluate(ActivatedFeatureExpression activatedFeatureExpression) {
        return this.featureCheckService.isActive(activatedFeatureExpression.getFeature());
    }

    protected boolean _evaluate(NotFeatureExpression notFeatureExpression) {
        boolean _evaluate = this.evaluate(notFeatureExpression.getFeatureExpression());
        return !_evaluate;
    }

    protected boolean _evaluate(AnyOfFeatureExpression anyOfFeatureExpression) {
        Functions.Function1 _function = it -> this.evaluate((FeatureExpression)it);
        return IterableExtensions.exists(anyOfFeatureExpression.getFeatureExpressions(), (Functions.Function1)_function);
    }

    protected boolean _evaluate(AllOfFeatureExpression allOfFeatureExpression) {
        Functions.Function1 _function = it -> this.evaluate((FeatureExpression)it);
        return IterableExtensions.forall(allOfFeatureExpression.getFeatureExpressions(), (Functions.Function1)_function);
    }

    protected boolean evaluate(FeatureExpression activatedFeatureExpression) {
        if (activatedFeatureExpression instanceof ActivatedFeatureExpression) {
            return this._evaluate((ActivatedFeatureExpression)activatedFeatureExpression);
        }
        if (activatedFeatureExpression instanceof AllOfFeatureExpression) {
            return this._evaluate((AllOfFeatureExpression)activatedFeatureExpression);
        }
        if (activatedFeatureExpression instanceof AnyOfFeatureExpression) {
            return this._evaluate((AnyOfFeatureExpression)activatedFeatureExpression);
        }
        if (activatedFeatureExpression instanceof NotFeatureExpression) {
            return this._evaluate((NotFeatureExpression)activatedFeatureExpression);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(activatedFeatureExpression).toString());
    }
}

