/*
 * Decompiled with CFR 0.152.
 */
package de.bmiag.tapir.variant.feature.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import de.bmiag.tapir.data.Immutable;
import de.bmiag.tapir.variant.feature.Feature;
import de.bmiag.tapir.variant.feature.expression.FeatureExpression;
import java.util.ArrayList;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Immutable
public final class ActivatedFeatureExpression
implements FeatureExpression {
    private final Class<? extends Feature> feature;

    private ActivatedFeatureExpression(Class<? extends Feature> feature) {
        this.feature = feature;
    }

    public Class<? extends Feature> getFeature() {
        return this.feature;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActivatedFeatureExpression other = (ActivatedFeatureExpression)obj;
        return !(this.feature == null ? other.feature != null : !this.feature.equals(other.feature));
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.feature == null ? 0 : this.feature.hashCode());
        return result;
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this).skipNulls();
        b.add("feature", this.feature);
        return b.toString();
    }

    public static ActivatedFeatureExpression build(Procedures.Procedure1<Builder> init) {
        Builder builder = new Builder();
        init.apply((Object)builder);
        return builder.build();
    }

    public ActivatedFeatureExpression copy(Procedures.Procedure1<Builder> init) {
        Builder builder = Builder.from(this);
        init.apply((Object)builder);
        return builder.build();
    }

    public static final class Builder {
        private static final long INIT_BIT_FEATURE = 1L;
        private long initBits = 1L;
        private Class<? extends Feature> feature;

        private Builder() {
        }

        public void setFeature(Class<? extends Feature> feature) {
            this.feature = (Class)Preconditions.checkNotNull(feature, (Object)"feature");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        }

        private ActivatedFeatureExpression build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ActivatedFeatureExpression(this.feature);
        }

        private static Builder from(ActivatedFeatureExpression instance) {
            Builder builder = new Builder();
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            builder.setFeature(instance.getFeature());
            return builder;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("feature");
            }
            return "Cannot build ActivatedFeatureExpression, some of the required attributes are not set " + attributes;
        }
    }
}

