/*
 * Decompiled with CFR 0.152.
 */
package de.bmiag.tapir.variant.annotation.variant;

import com.google.common.collect.Iterables;
import de.bmiag.tapir.variant.annotation.variant.Variant;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.CompilationStrategy;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

public class VariantProcessor
extends AbstractClassProcessor {
    public void doTransform(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        this.addVariantInterface(annotatedClass, context);
        this.addConfigurationAnnotation(annotatedClass, context);
        this.addPropertyAnnotation(annotatedClass, context);
        this.addNameField(annotatedClass, context);
        this.addVariantBean(annotatedClass, context);
        this.addFeatureBeanMethods(annotatedClass, context);
        this.removeVariantAnnotation(annotatedClass, context);
    }

    private void addVariantInterface(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        Type variantInterfaceType = context.findTypeGlobally(de.bmiag.tapir.variant.Variant.class);
        Iterable _implementedInterfaces = annotatedClass.getImplementedInterfaces();
        TypeReference _newTypeReference = context.newTypeReference(variantInterfaceType, new TypeReference[0]);
        Iterable _plus = Iterables.concat((Iterable)_implementedInterfaces, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{_newTypeReference})));
        annotatedClass.setImplementedInterfaces(_plus);
    }

    private AnnotationReference addConfigurationAnnotation(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        return annotatedClass.addAnnotation(context.newAnnotationReference(Configuration.class));
    }

    private AnnotationReference addPropertyAnnotation(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        AnnotationReference _xblockexpression = null;
        String variantName = this.getVariantName(annotatedClass, context);
        Procedures.Procedure1 _function = annotationReferenceBuildContext -> {
            annotationReferenceBuildContext.setStringValue("name", new String[]{"variant"});
            annotationReferenceBuildContext.setStringValue("havingValue", new String[]{variantName});
        };
        AnnotationReference propertyAnnotationRef = context.newAnnotationReference(ConditionalOnProperty.class, _function);
        _xblockexpression = annotatedClass.addAnnotation(propertyAnnotationRef);
        return _xblockexpression;
    }

    private String getVariantName(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        String _xblockexpression = null;
        AnnotationReference variantAnnotation = this.getVariantAnnotation(annotatedClass, context);
        String name = variantAnnotation.getStringValue("name");
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)name);
        if (_isNullOrEmpty) {
            name = annotatedClass.getSimpleName();
        }
        _xblockexpression = name;
        return _xblockexpression;
    }

    private AnnotationReference getVariantAnnotation(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        return annotatedClass.findAnnotation(context.findTypeGlobally(Variant.class));
    }

    private MutableFieldDeclaration addNameField(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        MutableFieldDeclaration _xblockexpression = null;
        String variantName = this.getVariantName(annotatedClass, context);
        Procedures.Procedure1 _function = it -> {
            it.setType(context.newTypeReference(String.class, new TypeReference[0]));
            it.setStatic(true);
            it.setFinal(true);
            it.setVisibility(Visibility.PUBLIC);
            CompilationStrategy _function_1 = it_1 -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("\"");
                _builder.append(variantName);
                _builder.append("\"");
                return _builder;
            };
            it.setInitializer(_function_1);
        };
        _xblockexpression = annotatedClass.addField("NAME", _function);
        return _xblockexpression;
    }

    private MutableMethodDeclaration addVariantBean(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        Procedures.Procedure1 _function = it -> {
            it.addAnnotation(context.newAnnotationReference(Bean.class));
            it.setReturnType(context.newTypeReference(String.class, new TypeReference[0]));
            CompilationStrategy _function_1 = it_1 -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("return ");
                String _simpleName = annotatedClass.getSimpleName();
                _builder.append(_simpleName);
                _builder.append(".NAME;");
                _builder.newLineIfNotEmpty();
                return _builder;
            };
            it.setBody(_function_1);
        };
        return annotatedClass.addMethod("variant", _function);
    }

    private void addFeatureBeanMethods(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        AnnotationReference variantAnnotation = this.getVariantAnnotation(annotatedClass, context);
        TypeReference[] features = variantAnnotation.getClassArrayValue("features");
        Consumer<TypeReference> _function = featureTypeRef -> {
            Procedures.Procedure1 _function_1 = it -> {
                it.addAnnotation(context.newAnnotationReference(Bean.class));
                Procedures.Procedure1 _function_2 = it_1 -> {
                    String _qualifiedName = featureTypeRef.getType().getQualifiedName();
                    String _plus = _qualifiedName + ".active";
                    it_1.setStringValue("name", new String[]{_plus});
                    it_1.setStringValue("havingValue", new String[]{"true"});
                    it_1.setBooleanValue("matchIfMissing", new boolean[]{true});
                };
                it.addAnnotation(context.newAnnotationReference(ConditionalOnProperty.class, _function_2));
                it.setReturnType(featureTypeRef);
                CompilationStrategy _function_3 = it_1 -> {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("return new ");
                    String _javaCode = it_1.toJavaCode(featureTypeRef);
                    _builder.append(_javaCode);
                    _builder.append("();");
                    _builder.newLineIfNotEmpty();
                    return _builder;
                };
                it.setBody(_function_3);
            };
            annotatedClass.addMethod(featureTypeRef.getSimpleName().toLowerCase(), _function_1);
        };
        ((List)Conversions.doWrapArray((Object)features)).forEach(_function);
    }

    private boolean removeVariantAnnotation(MutableClassDeclaration annotatedClass, @Extension TransformationContext context) {
        boolean _xblockexpression = false;
        AnnotationReference variantAnnotation = this.getVariantAnnotation(annotatedClass, context);
        _xblockexpression = annotatedClass.removeAnnotation(variantAnnotation);
        return _xblockexpression;
    }
}

