/*
 * Decompiled with CFR 0.152.
 */
package de.bmiag.tapir.executiontest.listener;

import de.bmiag.tapir.execution.executor.ExecutionListener;
import de.bmiag.tapir.execution.model.ExecutionPlan;
import de.bmiag.tapir.execution.model.Parameterized;
import de.bmiag.tapir.execution.model.TestClass;
import de.bmiag.tapir.execution.model.TestStep;
import de.bmiag.tapir.execution.model.TestSuite;
import de.bmiag.tapir.executiontest.data.ExecutionState;
import de.bmiag.tapir.executiontest.expectation.execution.ComparableThrowable;
import de.bmiag.tapir.executiontest.expectation.execution.ExecutionPlanExecutionResult;
import de.bmiag.tapir.executiontest.expectation.execution.ExecutionResult;
import de.bmiag.tapir.executiontest.expectation.execution.TestClassExecutionResult;
import de.bmiag.tapir.executiontest.expectation.execution.TestStepExecutionResult;
import de.bmiag.tapir.executiontest.expectation.execution.TestSuiteExecutionResult;
import de.bmiag.tapir.executiontest.expectation.plan.TestParameterExpectation;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-5000)
public class TestExecutionListener
implements ExecutionListener {
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private List<ExecutionResult> results = Collections.synchronizedList(CollectionLiterals.newArrayList());

    public void suiteStarted(TestSuite testSuite) {
    }

    public void suiteSucceeded(TestSuite testSuite) {
        Procedures.Procedure1 procedure1 = it -> {
            it.setJavaClass(testSuite.getJavaClass());
            it.setExecutionState(ExecutionState.SUCCEEDED);
        };
        TestSuiteExecutionResult testSuiteExecutionResult = TestSuiteExecutionResult.build((Procedures.Procedure1<TestSuiteExecutionResult.Builder>)procedure1);
        this.results.add(testSuiteExecutionResult);
    }

    public void suiteFailed(TestSuite testSuite, Throwable throwable) {
        Procedures.Procedure1 procedure1 = it -> {
            it.setJavaClass(testSuite.getJavaClass());
            it.setExecutionState(ExecutionState.FAILED);
            Procedures.Procedure1 procedure1 = it_1 -> {
                it_1.setThrowableClass(throwable.getClass());
                it_1.setMessage(throwable.getMessage());
            };
            it.setComparableThrowable(ComparableThrowable.build((Procedures.Procedure1<ComparableThrowable.Builder>)procedure1));
        };
        TestSuiteExecutionResult testSuiteExecutionResult = TestSuiteExecutionResult.build((Procedures.Procedure1<TestSuiteExecutionResult.Builder>)procedure1);
        this.results.add(testSuiteExecutionResult);
    }

    public void suiteSkipped(TestSuite testSuite) {
        Procedures.Procedure1 procedure1 = it -> {
            it.setJavaClass(testSuite.getJavaClass());
            it.setExecutionState(ExecutionState.SKIPPED);
        };
        TestSuiteExecutionResult testSuiteExecutionResult = TestSuiteExecutionResult.build((Procedures.Procedure1<TestSuiteExecutionResult.Builder>)procedure1);
        this.results.add(testSuiteExecutionResult);
    }

    public void classStarted(TestClass testClass) {
    }

    public void classSucceeded(TestClass testClass) {
        Procedures.Procedure1 procedure1 = it -> {
            it.setJavaClass(testClass.getJavaClass());
            Functions.Function1 function1 = param -> {
                Procedures.Procedure1 procedure1 = it_1 -> {
                    it_1.setName(param.getName());
                    it_1.setValue(param.getValue());
                };
                return TestParameterExpectation.build((Procedures.Procedure1<TestParameterExpectation.Builder>)procedure1);
            };
            it.setParameters(ListExtensions.map((List)testClass.getParameters(), (Functions.Function1)function1));
            it.setExecutionState(ExecutionState.SUCCEEDED);
        };
        TestClassExecutionResult testClassExecutionResult = TestClassExecutionResult.build((Procedures.Procedure1<TestClassExecutionResult.Builder>)procedure1);
        this.results.add(testClassExecutionResult);
    }

    public void classFailed(TestClass testClass, Throwable throwable) {
        Procedures.Procedure1 procedure1 = it -> {
            it.setJavaClass(testClass.getJavaClass());
            Functions.Function1 function1 = param -> {
                Procedures.Procedure1 procedure1 = it_1 -> {
                    it_1.setName(param.getName());
                    it_1.setValue(param.getValue());
                };
                return TestParameterExpectation.build((Procedures.Procedure1<TestParameterExpectation.Builder>)procedure1);
            };
            it.setParameters(ListExtensions.map((List)testClass.getParameters(), (Functions.Function1)function1));
            it.setExecutionState(ExecutionState.FAILED);
            Procedures.Procedure1 procedure1 = it_1 -> {
                it_1.setThrowableClass(throwable.getClass());
                it_1.setMessage(throwable.getMessage());
            };
            it.setComparableThrowable(ComparableThrowable.build((Procedures.Procedure1<ComparableThrowable.Builder>)procedure1));
        };
        TestClassExecutionResult testClassExecutionResult = TestClassExecutionResult.build((Procedures.Procedure1<TestClassExecutionResult.Builder>)procedure1);
        this.results.add(testClassExecutionResult);
    }

    public void classSkipped(TestClass testClass) {
        Procedures.Procedure1 procedure1 = it -> {
            it.setJavaClass(testClass.getJavaClass());
            it.setParameters(this.mapParameters((Parameterized)testClass));
            it.setExecutionState(ExecutionState.SKIPPED);
        };
        TestClassExecutionResult testClassExecutionResult = TestClassExecutionResult.build((Procedures.Procedure1<TestClassExecutionResult.Builder>)procedure1);
        this.results.add(testClassExecutionResult);
    }

    private List<TestParameterExpectation> mapParameters(Parameterized parameterized) {
        Functions.Function1 function1 = param -> {
            Procedures.Procedure1 procedure1 = it -> {
                it.setName(param.getName());
                it.setValue(param.getValue());
            };
            return TestParameterExpectation.build((Procedures.Procedure1<TestParameterExpectation.Builder>)procedure1);
        };
        return ListExtensions.map((List)parameterized.getParameters(), (Functions.Function1)function1);
    }

    public void stepStarted(TestStep testStep) {
    }

    public void stepSucceeded(TestStep testStep) {
        Procedures.Procedure1 procedure1 = it -> {
            it.setName(testStep.getName());
            it.setJavaClass(testStep.getParentTestClass().getJavaClass());
            it.setTestClassParameters(this.mapParameters((Parameterized)testStep.getParentTestClass()));
            it.setExecutionState(ExecutionState.SUCCEEDED);
        };
        TestStepExecutionResult testStepExecutionResult = TestStepExecutionResult.build((Procedures.Procedure1<TestStepExecutionResult.Builder>)procedure1);
        this.results.add(testStepExecutionResult);
    }

    public void stepFailed(TestStep testStep, Throwable throwable) {
        Procedures.Procedure1 procedure1 = it -> {
            it.setName(testStep.getName());
            it.setJavaClass(testStep.getParentTestClass().getJavaClass());
            it.setTestClassParameters(this.mapParameters((Parameterized)testStep.getParentTestClass()));
            it.setExecutionState(ExecutionState.FAILED);
            Procedures.Procedure1 procedure1 = it_1 -> {
                it_1.setThrowableClass(throwable.getClass());
                it_1.setMessage(throwable.getMessage());
            };
            it.setComparableThrowable(ComparableThrowable.build((Procedures.Procedure1<ComparableThrowable.Builder>)procedure1));
        };
        TestStepExecutionResult testStepExecutionResult = TestStepExecutionResult.build((Procedures.Procedure1<TestStepExecutionResult.Builder>)procedure1);
        this.results.add(testStepExecutionResult);
    }

    public void stepSkipped(TestStep testStep) {
        Procedures.Procedure1 procedure1 = it -> {
            it.setName(testStep.getName());
            it.setJavaClass(testStep.getParentTestClass().getJavaClass());
            it.setTestClassParameters(this.mapParameters((Parameterized)testStep.getParentTestClass()));
            it.setExecutionState(ExecutionState.SKIPPED);
        };
        TestStepExecutionResult testStepExecutionResult = TestStepExecutionResult.build((Procedures.Procedure1<TestStepExecutionResult.Builder>)procedure1);
        this.results.add(testStepExecutionResult);
    }

    public void executionStarted(ExecutionPlan executionPlan) {
    }

    public void executionSucceeded(ExecutionPlan executionPlan) {
        Procedures.Procedure1 procedure1 = it -> it.setExecutionState(ExecutionState.SUCCEEDED);
        ExecutionPlanExecutionResult executionPlanExecutionResult = ExecutionPlanExecutionResult.build((Procedures.Procedure1<ExecutionPlanExecutionResult.Builder>)procedure1);
        this.results.add(executionPlanExecutionResult);
    }

    public void executionFailed(ExecutionPlan executionPlan, Throwable throwable) {
        Procedures.Procedure1 procedure1 = it -> {
            it.setExecutionState(ExecutionState.FAILED);
            Procedures.Procedure1 procedure1 = it_1 -> {
                it_1.setThrowableClass(throwable.getClass());
                it_1.setMessage(throwable.getMessage());
            };
            it.setComparableThrowable(ComparableThrowable.build((Procedures.Procedure1<ComparableThrowable.Builder>)procedure1));
        };
        ExecutionPlanExecutionResult executionPlanExecutionResult = ExecutionPlanExecutionResult.build((Procedures.Procedure1<ExecutionPlanExecutionResult.Builder>)procedure1);
        this.results.add(executionPlanExecutionResult);
    }

    @Pure
    public List<ExecutionResult> getResults() {
        return this.results;
    }
}

