/*
 * Decompiled with CFR 0.152.
 */
package de.bmiag.tapir.executiontest.expectation.plan;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.bmiag.tapir.data.Immutable;
import de.bmiag.tapir.execution.model.JavaClassBased;
import de.bmiag.tapir.executiontest.expectation.plan.StructuralElementExpectation;
import de.bmiag.tapir.executiontest.expectation.plan.StructuralElementExpectationContainer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Immutable(interfaces={JavaClassBased.class, StructuralElementExpectation.class, StructuralElementExpectationContainer.class})
public final class TestSuiteExpectation
implements JavaClassBased,
StructuralElementExpectation,
StructuralElementExpectationContainer {
    private final Class<?> javaClass;
    private final List<StructuralElementExpectation> children;

    private TestSuiteExpectation(Class<?> javaClass, List<StructuralElementExpectation> children) {
        this.javaClass = javaClass;
        this.children = children;
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public List<StructuralElementExpectation> getChildren() {
        return this.children;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestSuiteExpectation other = (TestSuiteExpectation)obj;
        if (this.javaClass == null ? other.javaClass != null : !this.javaClass.equals(other.javaClass)) {
            return false;
        }
        return !(this.children == null ? other.children != null : !this.children.equals(other.children));
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.javaClass == null ? 0 : this.javaClass.hashCode());
        return 31 * result + (this.children == null ? 0 : this.children.hashCode());
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this).skipNulls();
        b.add("javaClass", this.javaClass);
        b.add("children", this.children);
        return b.toString();
    }

    public static TestSuiteExpectation build(Procedures.Procedure1<Builder> init) {
        Builder builder = new Builder();
        init.apply((Object)builder);
        return builder.build();
    }

    public TestSuiteExpectation copy(Procedures.Procedure1<Builder> init) {
        Builder builder = Builder.from(this);
        init.apply((Object)builder);
        return builder.build();
    }

    public static final class Builder {
        private static final long INIT_BIT_JAVACLASS = 1L;
        private long initBits = 1L;
        private Class<?> javaClass;
        private ImmutableList.Builder<StructuralElementExpectation> children = ImmutableList.builder();

        private Builder() {
        }

        public void setJavaClass(Class<?> javaClass) {
            this.javaClass = (Class)Preconditions.checkNotNull(javaClass, (Object)"javaClass");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        }

        public void setChildren(Iterable<StructuralElementExpectation> elements) {
            this.children.addAll(elements);
        }

        private TestSuiteExpectation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new TestSuiteExpectation(this.javaClass, (List)this.children.build());
        }

        private static Builder from(TestSuiteExpectation instance) {
            Builder builder = new Builder();
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            builder.setJavaClass(instance.getJavaClass());
            builder.setChildren(instance.getChildren());
            return builder;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("javaClass");
            }
            return "Cannot build TestSuiteExpectation, some of the required attributes are not set " + attributes;
        }
    }
}

