/*
 * Decompiled with CFR 0.152.
 */
package de.bmiag.tapir.executiontest.expectation.plan;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.bmiag.tapir.data.Immutable;
import de.bmiag.tapir.executiontest.expectation.Parameterized;
import de.bmiag.tapir.executiontest.expectation.plan.TestParameterExpectation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Immutable(interfaces={Parameterized.class})
public final class TestStepExpectation
implements Parameterized {
    private final String methodName;
    private final List<TestParameterExpectation> parameters;

    private TestStepExpectation(String methodName, List<TestParameterExpectation> parameters) {
        this.methodName = methodName;
        this.parameters = parameters;
    }

    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public List<TestParameterExpectation> getParameters() {
        return this.parameters;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestStepExpectation other = (TestStepExpectation)obj;
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        return 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this).skipNulls();
        b.add("methodName", (Object)this.methodName);
        b.add("parameters", this.parameters);
        return b.toString();
    }

    public static TestStepExpectation build(Procedures.Procedure1<Builder> init) {
        Builder builder = new Builder();
        init.apply((Object)builder);
        return builder.build();
    }

    public TestStepExpectation copy(Procedures.Procedure1<Builder> init) {
        Builder builder = Builder.from(this);
        init.apply((Object)builder);
        return builder.build();
    }

    public static final class Builder {
        private static final long INIT_BIT_METHODNAME = 1L;
        private long initBits = 1L;
        private String methodName;
        private ImmutableList.Builder<TestParameterExpectation> parameters = ImmutableList.builder();

        private Builder() {
        }

        public void setMethodName(String methodName) {
            this.methodName = (String)Preconditions.checkNotNull((Object)methodName, (Object)"methodName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        }

        public void setParameters(Iterable<TestParameterExpectation> elements) {
            this.parameters.addAll(elements);
        }

        private TestStepExpectation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new TestStepExpectation(this.methodName, (List)this.parameters.build());
        }

        private static Builder from(TestStepExpectation instance) {
            Builder builder = new Builder();
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            builder.setMethodName(instance.getMethodName());
            builder.setParameters(instance.getParameters());
            return builder;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("methodName");
            }
            return "Cannot build TestStepExpectation, some of the required attributes are not set " + attributes;
        }
    }
}

