/*
 * Decompiled with CFR 0.152.
 */
package de.bmiag.tapir.executiontest.expectation.plan;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import de.bmiag.tapir.data.Immutable;
import java.util.ArrayList;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Immutable
public final class TestParameterExpectation {
    private final String name;
    private final Object value;

    private TestParameterExpectation(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestParameterExpectation other = (TestParameterExpectation)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return 31 * result + (this.value == null ? 0 : this.value.hashCode());
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this).skipNulls();
        b.add("name", (Object)this.name);
        b.add("value", this.value);
        return b.toString();
    }

    public static TestParameterExpectation build(Procedures.Procedure1<Builder> init) {
        Builder builder = new Builder();
        init.apply((Object)builder);
        return builder.build();
    }

    public TestParameterExpectation copy(Procedures.Procedure1<Builder> init) {
        Builder builder = Builder.from(this);
        init.apply((Object)builder);
        return builder.build();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        private String name;
        private Object value;

        private Builder() {
        }

        public void setName(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        }

        public void setValue(Object value) {
            this.value = Preconditions.checkNotNull((Object)value, (Object)"value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        }

        private TestParameterExpectation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new TestParameterExpectation(this.name, this.value);
        }

        private static Builder from(TestParameterExpectation instance) {
            Builder builder = new Builder();
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            builder.setName(instance.getName());
            builder.setValue(instance.getValue());
            return builder;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build TestParameterExpectation, some of the required attributes are not set " + attributes;
        }
    }
}

