/*
 * Decompiled with CFR 0.152.
 */
package de.bmiag.tapir.executiontest.expectation.plan;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.bmiag.tapir.data.Immutable;
import de.bmiag.tapir.execution.model.JavaClassBased;
import de.bmiag.tapir.executiontest.expectation.Parameterized;
import de.bmiag.tapir.executiontest.expectation.plan.StructuralElementExpectation;
import de.bmiag.tapir.executiontest.expectation.plan.TestParameterExpectation;
import de.bmiag.tapir.executiontest.expectation.plan.TestStepExpectation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Immutable(interfaces={JavaClassBased.class, Parameterized.class, StructuralElementExpectation.class})
public final class TestClassExpectation
implements JavaClassBased,
Parameterized,
StructuralElementExpectation {
    private final List<TestStepExpectation> steps;
    private final Class<?> javaClass;
    private final List<TestParameterExpectation> parameters;

    private TestClassExpectation(List<TestStepExpectation> steps, Class<?> javaClass, List<TestParameterExpectation> parameters) {
        this.steps = steps;
        this.javaClass = javaClass;
        this.parameters = parameters;
    }

    public List<TestStepExpectation> getSteps() {
        return this.steps;
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public List<TestParameterExpectation> getParameters() {
        return this.parameters;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestClassExpectation other = (TestClassExpectation)obj;
        if (this.steps == null ? other.steps != null : !this.steps.equals(other.steps)) {
            return false;
        }
        if (this.javaClass == null ? other.javaClass != null : !this.javaClass.equals(other.javaClass)) {
            return false;
        }
        return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.steps == null ? 0 : this.steps.hashCode());
        result = 31 * result + (this.javaClass == null ? 0 : this.javaClass.hashCode());
        return 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this).skipNulls();
        b.add("steps", this.steps);
        b.add("javaClass", this.javaClass);
        b.add("parameters", this.parameters);
        return b.toString();
    }

    public static TestClassExpectation build(Procedures.Procedure1<Builder> init) {
        Builder builder = new Builder();
        init.apply((Object)builder);
        return builder.build();
    }

    public TestClassExpectation copy(Procedures.Procedure1<Builder> init) {
        Builder builder = Builder.from(this);
        init.apply((Object)builder);
        return builder.build();
    }

    public static final class Builder {
        private static final long INIT_BIT_JAVACLASS = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<TestStepExpectation> steps = ImmutableList.builder();
        private Class<?> javaClass;
        private ImmutableList.Builder<TestParameterExpectation> parameters = ImmutableList.builder();

        private Builder() {
        }

        public void setSteps(Iterable<TestStepExpectation> elements) {
            this.steps.addAll(elements);
        }

        public void setJavaClass(Class<?> javaClass) {
            this.javaClass = (Class)Preconditions.checkNotNull(javaClass, (Object)"javaClass");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        }

        public void setParameters(Iterable<TestParameterExpectation> elements) {
            this.parameters.addAll(elements);
        }

        private TestClassExpectation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new TestClassExpectation((List)this.steps.build(), this.javaClass, (List)this.parameters.build());
        }

        private static Builder from(TestClassExpectation instance) {
            Builder builder = new Builder();
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            builder.setSteps(instance.getSteps());
            builder.setJavaClass(instance.getJavaClass());
            builder.setParameters(instance.getParameters());
            return builder;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("javaClass");
            }
            return "Cannot build TestClassExpectation, some of the required attributes are not set " + attributes;
        }
    }
}

