/*
 * Decompiled with CFR 0.152.
 */
package de.bmiag.tapir.executiontest.expectation.plan;

import de.bmiag.tapir.bootstrap.TapirBootstrapStrategy;
import de.bmiag.tapir.bootstrap.TapirBootstrapper;
import de.bmiag.tapir.bootstrap.TapirFactoriesBootstrapStrategy;
import de.bmiag.tapir.execution.TapirExecutor;
import de.bmiag.tapir.execution.model.ExecutionPlan;
import de.bmiag.tapir.executiontest.expectation.plan.ExecutionPlanAssertion;
import de.bmiag.tapir.executiontest.expectation.plan.ExecutionPlanExpectation;
import de.bmiag.tapir.executiontest.expectation.plan.StructuralElementExpectation;
import de.bmiag.tapir.executiontest.expectation.plan.TestClassExpectation;
import de.bmiag.tapir.executiontest.expectation.plan.TestParameterExpectation;
import de.bmiag.tapir.executiontest.expectation.plan.TestStepExpectation;
import de.bmiag.tapir.executiontest.expectation.plan.TestSuiteExpectation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.springframework.context.ConfigurableApplicationContext;

public class ExecutionPlanExpectationHelper {
    public ExecutionPlanExpectation executionPlan() {
        return this.executionPlan(CollectionLiterals.emptyList());
    }

    public ExecutionPlanExpectation executionPlan(List<StructuralElementExpectation> children) {
        Procedures.Procedure1 procedure1 = it -> it.setChildren(children);
        return ExecutionPlanExpectation.build((Procedures.Procedure1<ExecutionPlanExpectation.Builder>)procedure1);
    }

    public TestSuiteExpectation testSuite(Class<?> javaClass, List<StructuralElementExpectation> children) {
        Procedures.Procedure1 procedure1 = it -> {
            it.setJavaClass(javaClass);
            it.setChildren(children);
        };
        return TestSuiteExpectation.build((Procedures.Procedure1<TestSuiteExpectation.Builder>)procedure1);
    }

    public TestClassExpectation testClass(Class<?> javaClass, List<TestStepExpectation> steps) {
        return this.testClass(javaClass, CollectionLiterals.emptyList(), steps);
    }

    public TestClassExpectation testClass(Class<?> javaClass, TestParameterExpectation testParameter, List<TestStepExpectation> steps) {
        return this.testClass(javaClass, Collections.singletonList(testParameter), steps);
    }

    public TestClassExpectation testClass(Class<?> javaClass, List<TestParameterExpectation> testParameters, Iterable<TestStepExpectation> steps) {
        Procedures.Procedure1 procedure1 = it -> {
            it.setJavaClass(javaClass);
            it.setParameters(testParameters);
            it.setSteps(steps);
        };
        return TestClassExpectation.build((Procedures.Procedure1<TestClassExpectation.Builder>)procedure1);
    }

    public TestStepExpectation testStep(String name) {
        return this.testStep(name, CollectionLiterals.emptyList());
    }

    public TestStepExpectation testStep(String name, TestParameterExpectation testParameter) {
        return this.testStep(name, Collections.singletonList(testParameter));
    }

    public TestStepExpectation testStep(String name, List<TestParameterExpectation> testParameters) {
        Procedures.Procedure1 procedure1 = it -> {
            it.setMethodName(name);
            it.setParameters(testParameters);
        };
        return TestStepExpectation.build((Procedures.Procedure1<TestStepExpectation.Builder>)procedure1);
    }

    public TestParameterExpectation testParameter(String name, Object value) {
        Procedures.Procedure1 procedure1 = it -> {
            it.setName(name);
            it.setValue(value);
        };
        return TestParameterExpectation.build((Procedures.Procedure1<TestParameterExpectation.Builder>)procedure1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(Class<?> testClass, Map<String, String> properties, ExecutionPlanExpectation executionPlanExpectation) {
        Consumer<Map.Entry> consumer;
        try {
            consumer = it -> System.setProperty((String)it.getKey(), (String)it.getValue());
            properties.entrySet().forEach(consumer);
            ConfigurableApplicationContext applicationContext = TapirBootstrapper.bootstrap((TapirBootstrapStrategy)TapirFactoriesBootstrapStrategy.instance());
            TapirExecutor.TapirExecutorFactory tapirExecutorFactory = (TapirExecutor.TapirExecutorFactory)applicationContext.getBean(TapirExecutor.TapirExecutorFactory.class);
            TapirExecutor executor = tapirExecutorFactory.getExecutorForClass(testClass);
            ExecutionPlan actual = executor.getExecutionPlan();
            ExecutionPlanAssertion.doAssertion(executionPlanExpectation, actual);
        }
        finally {
            consumer = it -> System.clearProperty((String)it.getKey());
            properties.entrySet().forEach(consumer);
        }
    }

    public void runTest(Class<?> testClass, ExecutionPlanExpectation executionPlanExpectation) {
        this.runTest(testClass, CollectionLiterals.emptyMap(), executionPlanExpectation);
    }
}

