/*
 * Decompiled with CFR 0.152.
 */
package de.bmiag.tapir.executiontest.expectation.plan;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.bmiag.tapir.data.Immutable;
import de.bmiag.tapir.executiontest.expectation.plan.StructuralElementExpectation;
import de.bmiag.tapir.executiontest.expectation.plan.StructuralElementExpectationContainer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Immutable(interfaces={StructuralElementExpectationContainer.class})
public final class ExecutionPlanExpectation
implements StructuralElementExpectationContainer {
    private final List<StructuralElementExpectation> children;

    private ExecutionPlanExpectation(List<StructuralElementExpectation> children) {
        this.children = children;
    }

    @Override
    public List<StructuralElementExpectation> getChildren() {
        return this.children;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExecutionPlanExpectation other = (ExecutionPlanExpectation)obj;
        return !(this.children == null ? other.children != null : !this.children.equals(other.children));
    }

    @Pure
    public int hashCode() {
        return 31 + (this.children == null ? 0 : this.children.hashCode());
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this).skipNulls();
        b.add("children", this.children);
        return b.toString();
    }

    public static ExecutionPlanExpectation build(Procedures.Procedure1<Builder> init) {
        Builder builder = new Builder();
        init.apply((Object)builder);
        return builder.build();
    }

    public ExecutionPlanExpectation copy(Procedures.Procedure1<Builder> init) {
        Builder builder = Builder.from(this);
        init.apply((Object)builder);
        return builder.build();
    }

    public static final class Builder {
        private long initBits = 0L;
        private ImmutableList.Builder<StructuralElementExpectation> children = ImmutableList.builder();

        private Builder() {
        }

        public void setChildren(Iterable<StructuralElementExpectation> elements) {
            this.children.addAll(elements);
        }

        private ExecutionPlanExpectation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ExecutionPlanExpectation((List)this.children.build());
        }

        private static Builder from(ExecutionPlanExpectation instance) {
            Builder builder = new Builder();
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            builder.setChildren(instance.getChildren());
            return builder;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            return "Cannot build ExecutionPlanExpectation, some of the required attributes are not set " + attributes;
        }
    }
}

