/*
 * Decompiled with CFR 0.152.
 */
package de.bmiag.tapir.executiontest.expectation.plan;

import de.bmiag.tapir.execution.model.ExecutionPlan;
import de.bmiag.tapir.execution.model.StructuralElement;
import de.bmiag.tapir.execution.model.TestClass;
import de.bmiag.tapir.execution.model.TestParameter;
import de.bmiag.tapir.execution.model.TestStep;
import de.bmiag.tapir.execution.model.TestSuite;
import de.bmiag.tapir.executiontest.expectation.plan.ExecutionPlanExpectation;
import de.bmiag.tapir.executiontest.expectation.plan.StructuralElementExpectation;
import de.bmiag.tapir.executiontest.expectation.plan.TestClassExpectation;
import de.bmiag.tapir.executiontest.expectation.plan.TestParameterExpectation;
import de.bmiag.tapir.executiontest.expectation.plan.TestStepExpectation;
import de.bmiag.tapir.executiontest.expectation.plan.TestSuiteExpectation;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ClassAssert;
import org.assertj.core.api.ListAssert;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;

public class ExecutionPlanAssertion {
    public static void doAssertion(ExecutionPlanExpectation expected, ExecutionPlan actual) {
        ListAssert listAssert = Assertions.assertThat((List)actual.getChildren());
        StringConcatenation stringConcatenation = new StringConcatenation();
        String string = actual.getJavaClass().getName();
        stringConcatenation.append(string);
        stringConcatenation.append(" does not have the expected amount of children.");
        ((ListAssert)listAssert.withFailMessage(stringConcatenation.toString(), new Object[0])).hasSameSizeAs(expected.getChildren());
        int n = expected.getChildren().size();
        ExclusiveRange exclusiveRange = new ExclusiveRange(0, n, true);
        for (Integer i : exclusiveRange) {
            StructuralElementExpectation expectedChild = expected.getChildren().get(i);
            StructuralElement actualChild = (StructuralElement)actual.getChildren().get(i);
            ExecutionPlanAssertion.compareStructuralElement(expectedChild, actualChild);
        }
    }

    private static void _compareStructuralElement(TestSuiteExpectation expected, TestSuite actual) {
        ClassAssert classAssert = Assertions.assertThat((Class)actual.getJavaClass());
        StringConcatenation stringConcatenation = new StringConcatenation();
        String string = actual.getName();
        stringConcatenation.append(string);
        stringConcatenation.append(" is not based on the expected java class.");
        ((ClassAssert)classAssert.withFailMessage(stringConcatenation.toString(), new Object[0])).isEqualTo(expected.getJavaClass());
        ListAssert listAssert = Assertions.assertThat((List)actual.getChildren());
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        String string2 = actual.getJavaClass().getName();
        stringConcatenation2.append(string2);
        stringConcatenation2.append(" does not have the expected amount of children.");
        ((ListAssert)listAssert.withFailMessage(stringConcatenation2.toString(), new Object[0])).hasSameSizeAs(expected.getChildren());
        int n = expected.getChildren().size();
        ExclusiveRange exclusiveRange = new ExclusiveRange(0, n, true);
        for (Integer i : exclusiveRange) {
            StructuralElementExpectation expectedChild = expected.getChildren().get(i);
            StructuralElement actualChild = (StructuralElement)actual.getChildren().get(i);
            ExecutionPlanAssertion.compareStructuralElement(expectedChild, actualChild);
        }
    }

    private static void _compareStructuralElement(TestClassExpectation expected, TestClass actual) {
        ClassAssert classAssert = Assertions.assertThat((Class)actual.getJavaClass());
        StringConcatenation stringConcatenation = new StringConcatenation();
        String string = actual.getName();
        stringConcatenation.append(string);
        stringConcatenation.append(" is not based on the expected java class.");
        ((ClassAssert)classAssert.withFailMessage(stringConcatenation.toString(), new Object[0])).isEqualTo(expected.getJavaClass());
        ListAssert listAssert = Assertions.assertThat((List)actual.getParameters());
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        String string2 = actual.getName();
        stringConcatenation2.append(string2);
        stringConcatenation2.append(" does not have the expected amount of parameters.");
        ((ListAssert)listAssert.withFailMessage(stringConcatenation2.toString(), new Object[0])).hasSameSizeAs(expected.getParameters());
        int n = expected.getParameters().size();
        ExclusiveRange exclusiveRange = new ExclusiveRange(0, n, true);
        for (Integer i : exclusiveRange) {
            TestParameterExpectation expectedParameter = expected.getParameters().get(i);
            TestParameter actualParameter = (TestParameter)actual.getParameters().get(i);
            ExecutionPlanAssertion.compareTestParameter(expectedParameter, actualParameter);
        }
        ListIterator listIterator = Assertions.assertThat((List)actual.getSteps());
        StringConcatenation stringConcatenation3 = new StringConcatenation();
        String string3 = actual.getName();
        stringConcatenation3.append(string3);
        stringConcatenation3.append(" does not have the expected amount of steps.");
        ((ListAssert)listIterator.withFailMessage(stringConcatenation3.toString(), new Object[0])).hasSameSizeAs(expected.getSteps());
        int n2 = expected.getSteps().size();
        ExclusiveRange exclusiveRange2 = new ExclusiveRange(0, n2, true);
        for (Integer i_1 : exclusiveRange2) {
            TestStepExpectation expectedChild = expected.getSteps().get(i_1);
            TestStep actualChild = (TestStep)actual.getSteps().get(i_1);
            ExecutionPlanAssertion.compareStep(expectedChild, actualChild);
        }
    }

    private static void _compareStructuralElement(StructuralElementExpectation expected, TestClass actual) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("Expected: ");
        String string = expected.getClass().getName();
        stringConcatenation.append(string);
        stringConcatenation.append("; Actual: ");
        String string2 = actual.getClass().getName();
        stringConcatenation.append(string2);
        Assertions.fail((String)stringConcatenation.toString());
    }

    private static void compareTestParameter(TestParameterExpectation expected, TestParameter testParameter) {
        Assertions.assertThat((String)testParameter.getName()).isEqualTo((Object)expected.getName());
        Assertions.assertThat((Object)testParameter.getValue()).isEqualTo(expected.getValue());
    }

    private static void compareStep(TestStepExpectation expected, TestStep actual) {
        AbstractCharSequenceAssert abstractCharSequenceAssert = Assertions.assertThat((String)actual.getJavaMethod().getName());
        StringConcatenation stringConcatenation = new StringConcatenation();
        String string = actual.getName();
        stringConcatenation.append(string);
        stringConcatenation.append(" is not based on the expected java method.");
        ((AbstractCharSequenceAssert)abstractCharSequenceAssert.withFailMessage(stringConcatenation.toString(), new Object[0])).isEqualTo((Object)expected.getMethodName());
        ListAssert listAssert = Assertions.assertThat((List)actual.getParameters());
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        String string2 = actual.getName();
        stringConcatenation2.append(string2);
        stringConcatenation2.append(" does not have the expected amount of parameters.");
        ((ListAssert)listAssert.withFailMessage(stringConcatenation2.toString(), new Object[0])).hasSameSizeAs(expected.getParameters());
        int n = expected.getParameters().size();
        ExclusiveRange exclusiveRange = new ExclusiveRange(0, n, true);
        for (Integer i : exclusiveRange) {
            TestParameterExpectation expectedParameter = expected.getParameters().get(i);
            TestParameter actualParameter = (TestParameter)actual.getParameters().get(i);
            ExecutionPlanAssertion.compareTestParameter(expectedParameter, actualParameter);
        }
    }

    private static void compareStructuralElement(StructuralElementExpectation expected, Object actual) {
        if (expected instanceof TestClassExpectation && actual instanceof TestClass) {
            ExecutionPlanAssertion._compareStructuralElement((TestClassExpectation)expected, (TestClass)actual);
            return;
        }
        if (expected instanceof TestSuiteExpectation && actual instanceof TestSuite) {
            ExecutionPlanAssertion._compareStructuralElement((TestSuiteExpectation)expected, (TestSuite)actual);
            return;
        }
        if (expected != null && actual instanceof TestClass) {
            ExecutionPlanAssertion._compareStructuralElement(expected, (TestClass)actual);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expected, actual).toString());
    }
}

