/*
 * Decompiled with CFR 0.152.
 */
package de.bmiag.tapir.executiontest.expectation.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import de.bmiag.tapir.data.Immutable;
import de.bmiag.tapir.execution.model.JavaClassBased;
import de.bmiag.tapir.executiontest.data.ExecutionState;
import de.bmiag.tapir.executiontest.expectation.execution.ComparableThrowable;
import de.bmiag.tapir.executiontest.expectation.execution.ExecutionResult;
import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Immutable(interfaces={JavaClassBased.class, ExecutionResult.class})
public final class TestSuiteExecutionResult
implements JavaClassBased,
ExecutionResult {
    private final Class<?> javaClass;
    private final ExecutionState executionState;
    private final Optional<ComparableThrowable> comparableThrowable;

    private TestSuiteExecutionResult(Class<?> javaClass, ExecutionState executionState, Optional<ComparableThrowable> comparableThrowable) {
        this.javaClass = javaClass;
        this.executionState = executionState;
        this.comparableThrowable = comparableThrowable;
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    @Override
    public Optional<ComparableThrowable> getComparableThrowable() {
        return this.comparableThrowable;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestSuiteExecutionResult other = (TestSuiteExecutionResult)obj;
        if (this.javaClass == null ? other.javaClass != null : !this.javaClass.equals(other.javaClass)) {
            return false;
        }
        if (this.executionState == null ? other.executionState != null : !this.executionState.equals((Object)other.executionState)) {
            return false;
        }
        return !(this.comparableThrowable == null ? other.comparableThrowable != null : !this.comparableThrowable.equals(other.comparableThrowable));
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.javaClass == null ? 0 : this.javaClass.hashCode());
        result = 31 * result + (this.executionState == null ? 0 : this.executionState.hashCode());
        return 31 * result + (this.comparableThrowable == null ? 0 : this.comparableThrowable.hashCode());
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this).skipNulls();
        b.add("javaClass", this.javaClass);
        b.add("executionState", (Object)this.executionState);
        b.add("comparableThrowable", this.comparableThrowable.orElse(null));
        return b.toString();
    }

    public static TestSuiteExecutionResult build(Procedures.Procedure1<Builder> init) {
        Builder builder = new Builder();
        init.apply((Object)builder);
        return builder.build();
    }

    public TestSuiteExecutionResult copy(Procedures.Procedure1<Builder> init) {
        Builder builder = Builder.from(this);
        init.apply((Object)builder);
        return builder.build();
    }

    public static final class Builder {
        private static final long INIT_BIT_JAVACLASS = 1L;
        private static final long INIT_BIT_EXECUTIONSTATE = 2L;
        private long initBits = 3L;
        private Class<?> javaClass;
        private ExecutionState executionState;
        private Optional<ComparableThrowable> comparableThrowable = Optional.empty();

        private Builder() {
        }

        public void setJavaClass(Class<?> javaClass) {
            this.javaClass = (Class)Preconditions.checkNotNull(javaClass, (Object)"javaClass");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        }

        public void setExecutionState(ExecutionState executionState) {
            this.executionState = (ExecutionState)((Object)Preconditions.checkNotNull((Object)((Object)executionState), (Object)"executionState"));
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        }

        public void setComparableThrowable(Optional<ComparableThrowable> comparableThrowable) {
            this.comparableThrowable = (Optional)Preconditions.checkNotNull(comparableThrowable, (Object)"comparableThrowable");
        }

        public void setComparableThrowable(ComparableThrowable comparableThrowable) {
            this.comparableThrowable = Optional.of(comparableThrowable);
        }

        private TestSuiteExecutionResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new TestSuiteExecutionResult(this.javaClass, this.executionState, this.comparableThrowable);
        }

        private static Builder from(TestSuiteExecutionResult instance) {
            Builder builder = new Builder();
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            builder.setJavaClass(instance.getJavaClass());
            builder.setExecutionState(instance.getExecutionState());
            if (instance.getComparableThrowable().isPresent()) {
                builder.setComparableThrowable(instance.getComparableThrowable());
            }
            return builder;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("javaClass");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("executionState");
            }
            return "Cannot build TestSuiteExecutionResult, some of the required attributes are not set " + attributes;
        }
    }
}

