/*
 * Decompiled with CFR 0.152.
 */
package de.bmiag.tapir.executiontest.expectation.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.bmiag.tapir.data.Immutable;
import de.bmiag.tapir.execution.model.JavaClassBased;
import de.bmiag.tapir.executiontest.data.ExecutionState;
import de.bmiag.tapir.executiontest.expectation.Parameterized;
import de.bmiag.tapir.executiontest.expectation.execution.ComparableThrowable;
import de.bmiag.tapir.executiontest.expectation.execution.ExecutionResult;
import de.bmiag.tapir.executiontest.expectation.plan.TestParameterExpectation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Immutable(interfaces={JavaClassBased.class, Parameterized.class, ExecutionResult.class})
public final class TestClassExecutionResult
implements JavaClassBased,
Parameterized,
ExecutionResult {
    private final Class<?> javaClass;
    private final List<TestParameterExpectation> parameters;
    private final ExecutionState executionState;
    private final Optional<ComparableThrowable> comparableThrowable;

    private TestClassExecutionResult(Class<?> javaClass, List<TestParameterExpectation> parameters, ExecutionState executionState, Optional<ComparableThrowable> comparableThrowable) {
        this.javaClass = javaClass;
        this.parameters = parameters;
        this.executionState = executionState;
        this.comparableThrowable = comparableThrowable;
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public List<TestParameterExpectation> getParameters() {
        return this.parameters;
    }

    @Override
    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    @Override
    public Optional<ComparableThrowable> getComparableThrowable() {
        return this.comparableThrowable;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestClassExecutionResult other = (TestClassExecutionResult)obj;
        if (this.javaClass == null ? other.javaClass != null : !this.javaClass.equals(other.javaClass)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        if (this.executionState == null ? other.executionState != null : !this.executionState.equals((Object)other.executionState)) {
            return false;
        }
        return !(this.comparableThrowable == null ? other.comparableThrowable != null : !this.comparableThrowable.equals(other.comparableThrowable));
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.javaClass == null ? 0 : this.javaClass.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.executionState == null ? 0 : this.executionState.hashCode());
        return 31 * result + (this.comparableThrowable == null ? 0 : this.comparableThrowable.hashCode());
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this).skipNulls();
        b.add("javaClass", this.javaClass);
        b.add("parameters", this.parameters);
        b.add("executionState", (Object)this.executionState);
        b.add("comparableThrowable", this.comparableThrowable.orElse(null));
        return b.toString();
    }

    public static TestClassExecutionResult build(Procedures.Procedure1<Builder> init) {
        Builder builder = new Builder();
        init.apply((Object)builder);
        return builder.build();
    }

    public TestClassExecutionResult copy(Procedures.Procedure1<Builder> init) {
        Builder builder = Builder.from(this);
        init.apply((Object)builder);
        return builder.build();
    }

    public static final class Builder {
        private static final long INIT_BIT_JAVACLASS = 1L;
        private static final long INIT_BIT_EXECUTIONSTATE = 2L;
        private long initBits = 3L;
        private Class<?> javaClass;
        private ImmutableList.Builder<TestParameterExpectation> parameters = ImmutableList.builder();
        private ExecutionState executionState;
        private Optional<ComparableThrowable> comparableThrowable = Optional.empty();

        private Builder() {
        }

        public void setJavaClass(Class<?> javaClass) {
            this.javaClass = (Class)Preconditions.checkNotNull(javaClass, (Object)"javaClass");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        }

        public void setParameters(Iterable<TestParameterExpectation> elements) {
            this.parameters.addAll(elements);
        }

        public void setExecutionState(ExecutionState executionState) {
            this.executionState = (ExecutionState)((Object)Preconditions.checkNotNull((Object)((Object)executionState), (Object)"executionState"));
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        }

        public void setComparableThrowable(Optional<ComparableThrowable> comparableThrowable) {
            this.comparableThrowable = (Optional)Preconditions.checkNotNull(comparableThrowable, (Object)"comparableThrowable");
        }

        public void setComparableThrowable(ComparableThrowable comparableThrowable) {
            this.comparableThrowable = Optional.of(comparableThrowable);
        }

        private TestClassExecutionResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new TestClassExecutionResult(this.javaClass, (List)this.parameters.build(), this.executionState, this.comparableThrowable);
        }

        private static Builder from(TestClassExecutionResult instance) {
            Builder builder = new Builder();
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            builder.setJavaClass(instance.getJavaClass());
            builder.setParameters(instance.getParameters());
            builder.setExecutionState(instance.getExecutionState());
            if (instance.getComparableThrowable().isPresent()) {
                builder.setComparableThrowable(instance.getComparableThrowable());
            }
            return builder;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("javaClass");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("executionState");
            }
            return "Cannot build TestClassExecutionResult, some of the required attributes are not set " + attributes;
        }
    }
}

