/*
 * Decompiled with CFR 0.152.
 */
package de.bmiag.tapir.executiontest.expectation.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import de.bmiag.tapir.data.Immutable;
import java.util.ArrayList;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Immutable
public final class ComparableThrowable {
    private final Class<? extends Throwable> throwableClass;
    private final String message;

    private ComparableThrowable(Class<? extends Throwable> throwableClass, String message) {
        this.throwableClass = throwableClass;
        this.message = message;
    }

    public Class<? extends Throwable> getThrowableClass() {
        return this.throwableClass;
    }

    public String getMessage() {
        return this.message;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComparableThrowable other = (ComparableThrowable)obj;
        if (this.throwableClass == null ? other.throwableClass != null : !this.throwableClass.equals(other.throwableClass)) {
            return false;
        }
        return !(this.message == null ? other.message != null : !this.message.equals(other.message));
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.throwableClass == null ? 0 : this.throwableClass.hashCode());
        return 31 * result + (this.message == null ? 0 : this.message.hashCode());
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this).skipNulls();
        b.add("throwableClass", this.throwableClass);
        b.add("message", (Object)this.message);
        return b.toString();
    }

    public static ComparableThrowable build(Procedures.Procedure1<Builder> init) {
        Builder builder = new Builder();
        init.apply((Object)builder);
        return builder.build();
    }

    public ComparableThrowable copy(Procedures.Procedure1<Builder> init) {
        Builder builder = Builder.from(this);
        init.apply((Object)builder);
        return builder.build();
    }

    public static final class Builder {
        private static final long INIT_BIT_THROWABLECLASS = 1L;
        private static final long INIT_BIT_MESSAGE = 2L;
        private long initBits = 3L;
        private Class<? extends Throwable> throwableClass;
        private String message;

        private Builder() {
        }

        public void setThrowableClass(Class<? extends Throwable> throwableClass) {
            this.throwableClass = (Class)Preconditions.checkNotNull(throwableClass, (Object)"throwableClass");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        }

        public void setMessage(String message) {
            this.message = (String)Preconditions.checkNotNull((Object)message, (Object)"message");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        }

        private ComparableThrowable build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ComparableThrowable(this.throwableClass, this.message);
        }

        private static Builder from(ComparableThrowable instance) {
            Builder builder = new Builder();
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            builder.setThrowableClass(instance.getThrowableClass());
            builder.setMessage(instance.getMessage());
            return builder;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("throwableClass");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build ComparableThrowable, some of the required attributes are not set " + attributes;
        }
    }
}

