/*
 * KUtil
 * Copyright (C) 2021-2022 Moritz Zwerger
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

package de.bixilon.kutil.reflection.generic

import de.bixilon.kutil.cast.CastUtil.unsafeCast
import de.bixilon.kutil.unsafe.UnsafeUtil
import java.lang.reflect.ParameterizedType
import java.lang.reflect.Type

object GenericUtil {
    private val parameterizedClass = Class.forName("sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl")
    private val rawTypeField = parameterizedClass.getDeclaredField("rawType")
    private val offset = UnsafeUtil.UNSAFE.objectFieldOffset(rawTypeField)

    fun getGeneric(type: Type): Class<*> {
        val actualType = type.unsafeCast<ParameterizedType>().actualTypeArguments.first()
        return when {
            actualType is Class<*> -> actualType
            actualType::class.java == parameterizedClass -> UnsafeUtil.UNSAFE.getObject(actualType, offset).unsafeCast()
            else -> TODO("Can not get generic of $type")
        }
    }
}
