/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.stream;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\bJ\b\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/bixilon/kutil/stream/LimitedInputStream;", "Ljava/io/InputStream;", "stream", "limit", "", "<init>", "(Ljava/io/InputStream;J)V", "", "(Ljava/io/InputStream;I)V", "getStream", "()Ljava/io/InputStream;", "left", "available", "read", "b", "", "off", "len", "skip", "n", "kutil"})
public final class LimitedInputStream
extends InputStream {
    @NotNull
    private final InputStream stream;
    private long left;

    public LimitedInputStream(@NotNull InputStream stream, long limit) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.stream = stream;
        this.left = limit;
        if (limit < 0L) {
            throw new IllegalArgumentException("Limit can not be < 0: " + limit);
        }
    }

    @NotNull
    public final InputStream getStream() {
        return this.stream;
    }

    public LimitedInputStream(@NotNull InputStream stream, int limit) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this(stream, (long)limit);
    }

    @Override
    public int available() {
        return (int)Math.min(this.left, (long)this.stream.available());
    }

    @Override
    public int read() {
        if (this.left == 0L) {
            return -1;
        }
        int read = this.stream.read();
        if (read == -1) {
            return -1;
        }
        long l = this.left;
        this.left = l + -1L;
        return read;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (this.left == 0L) {
            return -1;
        }
        int length = (int)Math.min((long)len, this.left);
        int read = this.stream.read(b, off, length);
        if (read == -1) {
            return -1;
        }
        this.left -= (long)read;
        return read;
    }

    @Override
    public long skip(long n) {
        long n2 = Math.min(this.left, n);
        long skipped = this.stream.skip(n2);
        this.left -= skipped;
        return skipped;
    }
}

