/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.math.interpolation;

import de.bixilon.kutil.math.interpolation.InterpolateFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\u001f\u001a\u00020 2\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010!\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0017J\u0016\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u0017R\u001c\u0010\u0003\u001a\u00028\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR \u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u0000@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\u0012\u0010\tR \u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u0000@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\u0014\u0010\tR \u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u0000@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\u0016\u0010\tR\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006$"}, d2={"Lde/bixilon/kutil/math/interpolation/Interpolator;", "T", "", "initial", "function", "Lde/bixilon/kutil/math/interpolation/InterpolateFunction;", "<init>", "(Ljava/lang/Object;Lde/bixilon/kutil/math/interpolation/InterpolateFunction;)V", "getInitial", "()Ljava/lang/Object;", "setInitial", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "getFunction", "()Lde/bixilon/kutil/math/interpolation/InterpolateFunction;", "setFunction", "(Lde/bixilon/kutil/math/interpolation/InterpolateFunction;)V", "value", "getValue", "value0", "getValue0", "value1", "getValue1", "", "delta", "getDelta", "()F", "", "identical", "getIdentical", "()Z", "push", "", "add", "seconds", "step", "kutil"})
public final class Interpolator<T> {
    private T initial;
    @NotNull
    private InterpolateFunction<T> function;
    private T value;
    private T value0;
    private T value1;
    private float delta;
    private boolean identical;

    public Interpolator(T initial, @NotNull InterpolateFunction<T> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        this.initial = initial;
        this.function = function;
        this.value = this.initial;
        this.value0 = this.initial;
        this.value1 = this.initial;
    }

    public final T getInitial() {
        return this.initial;
    }

    public final void setInitial(T t) {
        this.initial = t;
    }

    @NotNull
    public final InterpolateFunction<T> getFunction() {
        return this.function;
    }

    public final void setFunction(@NotNull InterpolateFunction<T> interpolateFunction) {
        Intrinsics.checkNotNullParameter(interpolateFunction, (String)"<set-?>");
        this.function = interpolateFunction;
    }

    public final T getValue() {
        return this.value;
    }

    public final T getValue0() {
        return this.value0;
    }

    public final T getValue1() {
        return this.value1;
    }

    public final float getDelta() {
        return this.delta;
    }

    public final boolean getIdentical() {
        return this.identical;
    }

    public final void push(T value) {
        this.value0 = this.value1;
        this.value1 = value;
        this.identical = Intrinsics.areEqual(this.value0, this.value1);
        this.delta = 0.0f;
        this.value = this.value0;
    }

    public final void add(float delta) {
        if (this.delta >= 1.0f) {
            return;
        }
        this.delta += delta;
        if (this.identical) {
            return;
        }
        this.value = this.function.interpolate(this.delta, this.value0, this.value1);
    }

    public final void add(float seconds, float step) {
        this.add(seconds / step);
    }
}

