/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.math.interpolation;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u001e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\u000b"}, d2={"Lde/bixilon/kutil/math/interpolation/FloatInterpolation;", "", "<init>", "()V", "interpolateLinear", "", "delta", "start", "end", "interpolateExponential", "interpolateSine", "kutil"})
public final class FloatInterpolation {
    @NotNull
    public static final FloatInterpolation INSTANCE = new FloatInterpolation();

    private FloatInterpolation() {
    }

    public final float interpolateLinear(float delta, float start, float end) {
        if (delta <= 0.0f) {
            return start;
        }
        if (delta >= 1.0f) {
            return end;
        }
        return start + delta * (end - start);
    }

    public final float interpolateExponential(float delta, float start, float end) {
        if (delta <= 0.0f) {
            return start;
        }
        if (delta >= 1.0f) {
            return end;
        }
        return start + delta * delta * (end - start);
    }

    public final float interpolateSine(float delta, float start, float end) {
        if (delta <= 0.0f) {
            return start;
        }
        if (delta >= 1.0f) {
            return end;
        }
        return start + (float)Math.sin(delta * (float)Math.PI / 2.0f) * (end - start);
    }
}

