/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.enums;

import de.bixilon.kutil.bit.set.AbstractBitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010)\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001%B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\u0016\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u001b\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0016J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dH\u0096\u0002J\u0016\u0010\u001e\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0016J\u0016\u0010\u001f\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0016J\u0015\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010!\u001a\u00020\fH\u0016J\u0013\u0010\"\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010$H\u0096\u0002R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006&"}, d2={"Lde/bixilon/kutil/enums/BitEnumSet;", "T", "", "", "universe", "", "<init>", "([Ljava/lang/Enum;)V", "[Ljava/lang/Enum;", "bits", "Lde/bixilon/kutil/bit/set/AbstractBitSet;", "value", "", "size", "getSize", "()I", "add", "", "element", "(Ljava/lang/Enum;)Z", "addAll", "elements", "", "clear", "", "isEmpty", "contains", "containsAll", "iterator", "", "retainAll", "removeAll", "remove", "hashCode", "equals", "other", "", "EnumIterator", "kutil"})
public final class BitEnumSet<T extends Enum<?>>
implements Set<T>,
KMutableSet {
    @NotNull
    private final T[] universe;
    @NotNull
    private final AbstractBitSet bits;
    private int size;

    public BitEnumSet(@NotNull T[] universe) {
        Intrinsics.checkNotNullParameter(universe, (String)"universe");
        this.universe = universe;
        this.bits = AbstractBitSet.Companion.of(this.universe.length);
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public boolean add(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        int ordinal = ((Enum)element).ordinal();
        if (this.bits.get(ordinal)) {
            return false;
        }
        this.bits.set(ordinal, true);
        int n = this.size();
        this.size = n + 1;
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int added = 0;
        for (Enum element : elements) {
            int ordinal = element.ordinal();
            if (this.bits.get(ordinal)) continue;
            this.bits.set(ordinal, true);
            ++added;
        }
        this.size = this.size() + added;
        return added == elements.size();
    }

    @Override
    public void clear() {
        this.bits.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return this.bits.get(((Enum)element).ordinal());
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        for (Enum enum_ : elements) {
            if (this.contains(enum_)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new EnumIterator();
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int removed = 0;
        for (Enum enum_ : elements) {
            int ordinal = enum_.ordinal();
            if (!this.bits.get(ordinal)) continue;
            this.bits.set(ordinal, false);
            ++removed;
        }
        this.size = this.size() - removed;
        return removed == elements.size();
    }

    @Override
    public boolean remove(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        int ordinal = ((Enum)element).ordinal();
        if (!this.bits.get(ordinal)) {
            return false;
        }
        this.bits.set(ordinal, false);
        int n = this.size();
        this.size = n + -1;
        return true;
    }

    @Override
    public int hashCode() {
        return this.bits.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other instanceof BitEnumSet) {
            return ((BitEnumSet)other).universe == this.universe && Intrinsics.areEqual((Object)((BitEnumSet)other).bits, (Object)this.bits);
        }
        if (!(other instanceof Set)) {
            return false;
        }
        if (this.size() != ((Set)other).size()) {
            return false;
        }
        return ((Collection)this).containsAll((Collection)other);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\t\u0010\u0007\u001a\u00020\bH\u0096\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u0006\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/bixilon/kutil/enums/BitEnumSet$EnumIterator;", "", "<init>", "(Lde/bixilon/kutil/enums/BitEnumSet;)V", "current", "", "next", "hasNext", "", "setNext", "", "()Ljava/lang/Enum;", "remove", "kutil"})
    private final class EnumIterator
    implements Iterator<T>,
    KMutableIterator {
        private int current = -1;
        private int next = -1;

        @Override
        public boolean hasNext() {
            if (BitEnumSet.this.size() == 0) {
                return false;
            }
            this.setNext();
            if (this.next >= BitEnumSet.this.size()) {
                return false;
            }
            return this.next != this.current;
        }

        private final void setNext() {
            if (this.next != this.current) {
                return;
            }
            int n = BitEnumSet.this.size();
            for (int index = Math.max(this.next + 1, 0); index < n; ++index) {
                if (!BitEnumSet.this.bits.get(index)) continue;
                this.next = index;
                return;
            }
        }

        @Override
        @NotNull
        public T next() {
            if (this.next < 0 || this.current == this.next) {
                throw new IllegalStateException("There is no next!");
            }
            this.current = this.next;
            return BitEnumSet.this.universe[this.current];
        }

        @Override
        public void remove() {
            if (this.current < 0) {
                throw new IllegalStateException("Not iterating?");
            }
            if (this.current > BitEnumSet.this.size()) {
                return;
            }
            if (!BitEnumSet.this.bits.get(this.current)) {
                return;
            }
            BitEnumSet.this.bits.set(this.current, false);
            int n = BitEnumSet.this.size();
            BitEnumSet.this.size = n + -1;
        }
    }
}

