/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.pool;

import de.bixilon.kutil.concurrent.pool.PoolSubmitter;
import de.bixilon.kutil.concurrent.pool.ThreadPool;
import de.bixilon.kutil.concurrent.pool.runnable.InterruptableRunnable;
import de.bixilon.kutil.concurrent.pool.runnable.ThreadPoolRunnable;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lde/bixilon/kutil/concurrent/pool/ThreadPoolExecutor;", "", "running", "Ljava/util/concurrent/atomic/AtomicInteger;", "submitter", "Lde/bixilon/kutil/concurrent/pool/PoolSubmitter;", "pool", "Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "<init>", "(Ljava/util/concurrent/atomic/AtomicInteger;Lde/bixilon/kutil/concurrent/pool/PoolSubmitter;Lde/bixilon/kutil/concurrent/pool/ThreadPool;)V", "getRunning", "()Ljava/util/concurrent/atomic/AtomicInteger;", "getSubmitter", "()Lde/bixilon/kutil/concurrent/pool/PoolSubmitter;", "getPool", "()Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "run", "", "Lde/bixilon/kutil/concurrent/pool/runnable/ThreadPoolRunnable;", "Lde/bixilon/kutil/concurrent/pool/runnable/InterruptableRunnable;", "execute", "runnable", "kutil"})
public final class ThreadPoolExecutor {
    @NotNull
    private final AtomicInteger running;
    @NotNull
    private final PoolSubmitter submitter;
    @NotNull
    private final ThreadPool pool;

    public ThreadPoolExecutor(@NotNull AtomicInteger running, @NotNull PoolSubmitter submitter, @NotNull ThreadPool pool) {
        Intrinsics.checkNotNullParameter((Object)running, (String)"running");
        Intrinsics.checkNotNullParameter((Object)submitter, (String)"submitter");
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        this.running = running;
        this.submitter = submitter;
        this.pool = pool;
    }

    @NotNull
    public final AtomicInteger getRunning() {
        return this.running;
    }

    @NotNull
    public final PoolSubmitter getSubmitter() {
        return this.submitter;
    }

    @NotNull
    public final ThreadPool getPool() {
        return this.pool;
    }

    private final void run(ThreadPoolRunnable $this$run) {
        block0: {
            Runnable runnable2 = $this$run.getRunnable();
            if (runnable2 == null) break block0;
            runnable2.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void run(InterruptableRunnable $this$run) {
        try {
            $this$run.setThread(Thread.currentThread());
            Runnable runnable2 = $this$run.getRunnable();
            if (runnable2 != null) {
                runnable2.run();
            }
            $this$run.setThread(null);
        }
        catch (InterruptedException exception) {
            $this$run.setInterrupted(true);
            this.submitter.forceSubmit($this$run);
        }
        finally {
            $this$run.setThread(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(@NotNull ThreadPoolRunnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        try {
            this.running.incrementAndGet();
            if (runnable2 instanceof InterruptableRunnable) {
                this.run((InterruptableRunnable)runnable2);
            } else {
                this.run(runnable2);
            }
        }
        catch (Throwable exception) {
            Function1<Throwable, Unit> handler;
            Function1<Throwable, Unit> function1 = handler = this.pool.getErrorHandler();
            if (function1 == null) {
                exception.printStackTrace();
            } else {
                function1.invoke((Object)exception);
            }
        }
        finally {
            this.running.decrementAndGet();
        }
    }
}

