/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.pool;

import de.bixilon.kutil.concurrent.pool.PoolSubmitter;
import de.bixilon.kutil.concurrent.pool.ThreadPoolExecutor;
import de.bixilon.kutil.concurrent.pool.ThreadPoolStates;
import de.bixilon.kutil.concurrent.pool.runnable.SimplePoolRunnable;
import de.bixilon.kutil.concurrent.pool.runnable.ThreadPoolRunnable;
import de.bixilon.kutil.concurrent.pool.threads.ThreadManager;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u001f\n\u0002\b\u0007\b\u0016\u0018\u0000 H2\u00020\u0001:\u0001HBL\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012%\b\u0002\u0010\u0007\u001a\u001f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u0004\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020\u001cJ\u0010\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020-H\u0016J\u0011\u0010.\u001a\u00020\f2\u0006\u0010,\u001a\u00020\u001cH\u0086\u0002J\u0011\u0010.\u001a\u00020\f2\u0006\u0010,\u001a\u00020-H\u0086\u0002J\b\u0010/\u001a\u00020\fH\u0016J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020-01H\u0016J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000203H\u0016J\u0018\u00105\u001a\u0002032\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016J(\u0010:\u001a\b\u0012\u0004\u0012\u0002H<0;\"\n\b\u0000\u0010<*\u0004\u0018\u00010=2\f\u00106\u001a\b\u0012\u0004\u0012\u0002H<0>H\u0016J/\u0010:\u001a\b\u0012\u0004\u0012\u0002H<0;\"\n\b\u0000\u0010<*\u0004\u0018\u00010=2\u0006\u00106\u001a\u00020-2\u0006\u00108\u001a\u0002H<H\u0016\u00a2\u0006\u0002\u0010?J\u0014\u0010:\u001a\u0006\u0012\u0002\b\u00030;2\u0006\u00106\u001a\u00020-H\u0016J6\u0010@\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H<0;0A\"\n\b\u0000\u0010<*\u0004\u0018\u00010=2\u0014\u00106\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H<0>0BH\u0016JF\u0010@\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H<0;0A\"\n\b\u0000\u0010<*\u0004\u0018\u00010=2\u0014\u00106\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H<0>0B2\u0006\u00108\u001a\u0002072\u0006\u0010C\u001a\u000209H\u0016J/\u0010D\u001a\u0002H<\"\n\b\u0000\u0010<*\u0004\u0018\u00010=2\u0014\u00106\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H<0>0BH\u0016\u00a2\u0006\u0002\u0010EJ?\u0010D\u001a\u0002H<\"\n\b\u0000\u0010<*\u0004\u0018\u00010=2\u0014\u00106\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H<0>0B2\u0006\u00108\u001a\u0002072\u0006\u0010C\u001a\u000209H\u0016\u00a2\u0006\u0002\u0010FJ\u0006\u0010G\u001a\u000203R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R7\u0010\u0007\u001a\u001f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u0004\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020&X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0010\u00a8\u0006I"}, d2={"Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "Ljava/util/concurrent/ExecutorService;", "threadCount", "", "name", "", "priority", "errorHandler", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "exception", "", "<init>", "(ILjava/lang/String;ILkotlin/jvm/functions/Function1;)V", "getThreadCount", "()I", "getErrorHandler", "()Lkotlin/jvm/functions/Function1;", "setErrorHandler", "(Lkotlin/jvm/functions/Function1;)V", "value", "Lde/bixilon/kutil/concurrent/pool/ThreadPoolStates;", "state", "getState", "()Lde/bixilon/kutil/concurrent/pool/ThreadPoolStates;", "queue", "Ljava/util/concurrent/PriorityBlockingQueue;", "Lde/bixilon/kutil/concurrent/pool/runnable/ThreadPoolRunnable;", "running", "Ljava/util/concurrent/atomic/AtomicInteger;", "submitter", "Lde/bixilon/kutil/concurrent/pool/PoolSubmitter;", "getSubmitter$kutil", "()Lde/bixilon/kutil/concurrent/pool/PoolSubmitter;", "threads", "Lde/bixilon/kutil/concurrent/pool/threads/ThreadManager;", "executor", "Lde/bixilon/kutil/concurrent/pool/ThreadPoolExecutor;", "getExecutor$kutil", "()Lde/bixilon/kutil/concurrent/pool/ThreadPoolExecutor;", "queueSize", "getQueueSize", "execute", "runnable", "Ljava/lang/Runnable;", "plusAssign", "shutdown", "shutdownNow", "", "isShutdown", "", "isTerminated", "awaitTermination", "p0", "", "p1", "Ljava/util/concurrent/TimeUnit;", "submit", "Ljava/util/concurrent/Future;", "T", "", "Ljava/util/concurrent/Callable;", "(Ljava/lang/Runnable;Ljava/lang/Object;)Ljava/util/concurrent/Future;", "invokeAll", "", "", "p2", "invokeAny", "(Ljava/util/Collection;)Ljava/lang/Object;", "(Ljava/util/Collection;JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "isBacklogging", "Priorities", "kutil"})
@SourceDebugExtension(value={"SMAP\nThreadPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadPool.kt\nde/bixilon/kutil/concurrent/pool/ThreadPool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public class ThreadPool
implements ExecutorService {
    @NotNull
    public static final Priorities Priorities = new Priorities(null);
    private final int threadCount;
    @Nullable
    private Function1<? super Throwable, Unit> errorHandler;
    @NotNull
    private ThreadPoolStates state;
    @NotNull
    private final PriorityBlockingQueue<ThreadPoolRunnable> queue;
    @NotNull
    private final AtomicInteger running;
    @NotNull
    private final PoolSubmitter submitter;
    @NotNull
    private final ThreadManager threads;
    @NotNull
    private final ThreadPoolExecutor executor;
    public static final int HIGHEST = Integer.MAX_VALUE;
    public static final int HIGHER = 500;
    public static final int HIGH = 100;
    public static final int NORMAL = 0;
    public static final int LOW = -100;
    public static final int LOWER = -500;
    public static final int LOWEST = Integer.MIN_VALUE;

    public ThreadPool(int threadCount, @NotNull String name, int priority, @Nullable Function1<? super Throwable, Unit> errorHandler) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.threadCount = threadCount;
        this.errorHandler = errorHandler;
        this.state = ThreadPoolStates.STARTING;
        this.queue = new PriorityBlockingQueue();
        this.running = new AtomicInteger();
        this.submitter = new PoolSubmitter(this.queue, this.running, this.threadCount);
        this.threads = new ThreadManager(name, this.threadCount, priority, this.running, this, this.queue);
        this.executor = new ThreadPoolExecutor(this.running, this.submitter, this);
        if (!(this.threadCount >= 1)) {
            boolean bl = false;
            String string = "Can not have < 1 thread!";
            throw new IllegalStateException(string.toString());
        }
        this.threads.start();
        this.state = ThreadPoolStates.STARTED;
    }

    public /* synthetic */ ThreadPool(int n, String string, int n2, Function1 function1, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = Runtime.getRuntime().availableProcessors();
        }
        if ((n3 & 2) != 0) {
            string = "Worker#%d";
        }
        if ((n3 & 4) != 0) {
            n2 = 1;
        }
        if ((n3 & 8) != 0) {
            function1 = null;
        }
        this(n, string, n2, (Function1<? super Throwable, Unit>)function1);
    }

    public final int getThreadCount() {
        return this.threadCount;
    }

    @Nullable
    public final Function1<Throwable, Unit> getErrorHandler() {
        return this.errorHandler;
    }

    public final void setErrorHandler(@Nullable Function1<? super Throwable, Unit> function1) {
        this.errorHandler = function1;
    }

    @NotNull
    public final ThreadPoolStates getState() {
        return this.state;
    }

    @NotNull
    public final PoolSubmitter getSubmitter$kutil() {
        return this.submitter;
    }

    @NotNull
    public final ThreadPoolExecutor getExecutor$kutil() {
        return this.executor;
    }

    public final int getQueueSize() {
        return this.queue.size();
    }

    public final void execute(@NotNull ThreadPoolRunnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        if (this.submitter.submit(runnable2)) {
            return;
        }
        this.executor.execute(runnable2);
    }

    @Override
    public void execute(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        this.execute(new SimplePoolRunnable(0, runnable2, 1, null));
    }

    public final void plusAssign(@NotNull ThreadPoolRunnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        this.execute(runnable2);
    }

    public final void plusAssign(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        this.execute(runnable2);
    }

    @Override
    public void shutdown() {
        this.state = ThreadPoolStates.STOPPING;
        while (this.threads.getRunning().get() > 0) {
            Thread.sleep(1L);
        }
        this.state = ThreadPoolStates.STOPPED;
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        this.state = ThreadPoolStates.STOPPING;
        this.state = ThreadPoolStates.STOPPED;
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return this.state == ThreadPoolStates.STOPPING;
    }

    @Override
    public boolean isTerminated() {
        return this.state == ThreadPoolStates.STOPPED;
    }

    @Override
    public boolean awaitTermination(long p0, @NotNull TimeUnit p1) {
        Intrinsics.checkNotNullParameter((Object)((Object)p1), (String)"p1");
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> p0) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Runnable p0, T p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> p0) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> p0, long p1, @NotNull TimeUnit p2) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)((Object)p2), (String)"p2");
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> p0) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> p0, long p1, @NotNull TimeUnit p2) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)((Object)p2), (String)"p2");
        throw new NotImplementedError(null, 1, null);
    }

    public final boolean isBacklogging() {
        return this.queue.size() > 0;
    }

    public ThreadPool() {
        this(0, null, 0, null, 15, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/bixilon/kutil/concurrent/pool/ThreadPool$Priorities;", "", "<init>", "()V", "HIGHEST", "", "HIGHER", "HIGH", "NORMAL", "LOW", "LOWER", "LOWEST", "kutil"})
    public static final class Priorities {
        private Priorities() {
        }

        public /* synthetic */ Priorities(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

