/*
 * KUtil
 * Copyright (C) 2021-2022 Moritz Zwerger
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

package de.bixilon.kutil.unsafe

import de.bixilon.kutil.exception.Broken
import sun.misc.Unsafe
import java.lang.reflect.Modifier

object UnsafeUtil {
    val UNSAFE: Unsafe = retrieve()

    private fun retrieve(): Unsafe {
        val field = Unsafe::class.java.declaredFields.find { it.type == Unsafe::class.java && Modifier.isStatic(it.modifiers) } ?: Broken("Can not find unsafe!")
        // can not use get field, the name differs from platform to platform
        field.isAccessible = true
        return field[null] as Unsafe
    }

    fun hardCrash() {
        UNSAFE.putAddress(0, 0)
    }
}
