/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.math.interpolation;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"Lde/bixilon/kutil/math/interpolation/DoubleInterpolation;", "", "()V", "interpolateExponential", "", "delta", "start", "end", "interpolateLinear", "interpolateSine", "kutil"})
public final class DoubleInterpolation {
    @NotNull
    public static final DoubleInterpolation INSTANCE = new DoubleInterpolation();

    private DoubleInterpolation() {
    }

    public final double interpolateLinear(double delta, double start, double end) {
        if (delta <= 0.0) {
            return start;
        }
        if (delta >= 1.0) {
            return end;
        }
        return start + delta * (end - start);
    }

    public final double interpolateExponential(double delta, double start, double end) {
        if (delta <= 0.0) {
            return start;
        }
        if (delta >= 1.0) {
            return end;
        }
        return start + delta * delta * (end - start);
    }

    public final double interpolateSine(double delta, double start, double end) {
        if (delta <= 0.0) {
            return start;
        }
        if (delta >= 1.0) {
            return end;
        }
        return start + Math.sin(delta * Math.PI / 2.0) * (end - start);
    }
}

