/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.time;

import de.bixilon.kutil.concurrent.lock.simple.SimpleLock;
import de.bixilon.kutil.concurrent.pool.DefaultThreadPool;
import de.bixilon.kutil.concurrent.pool.ThreadPoolRunnable;
import de.bixilon.kutil.concurrent.time.TimeWorkerTask;
import de.bixilon.kutil.time.TimeUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0011\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0086\u0002J\u0011\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0086\u0002J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0016\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/bixilon/kutil/concurrent/time/TimeWorker;", "", "()V", "TASKS", "", "Lde/bixilon/kutil/concurrent/time/TimeWorkerTask;", "taskLock", "Lde/bixilon/kutil/concurrent/lock/simple/SimpleLock;", "addTask", "", "task", "minusAssign", "plusAssign", "removeTask", "runLater", "millis", "", "runnable", "Ljava/lang/Runnable;", "kutil"})
public final class TimeWorker {
    @NotNull
    public static final TimeWorker INSTANCE = new TimeWorker();
    @NotNull
    private static final Set<TimeWorkerTask> TASKS = new LinkedHashSet();
    @NotNull
    private static final SimpleLock taskLock = new SimpleLock();

    private TimeWorker() {
    }

    @NotNull
    public final TimeWorkerTask runLater(int millis, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        TimeWorkerTask task = new TimeWorkerTask(millis, true, 0, 0, runnable, 12, null);
        task.setLastExecution(TimeUtil.INSTANCE.millis());
        this.addTask(task);
        return task;
    }

    public final void addTask(@NotNull TimeWorkerTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        taskLock.lock();
        ((Collection)TASKS).add(task);
        taskLock.unlock();
    }

    public final void plusAssign(@NotNull TimeWorkerTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.addTask(task);
    }

    public final void removeTask(@NotNull TimeWorkerTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        taskLock.lock();
        ((Collection)TASKS).remove(task);
        taskLock.unlock();
    }

    public final void minusAssign(@NotNull TimeWorkerTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.removeTask(task);
    }

    private static final void lambda$1$lambda$0(TimeWorkerTask $task, long $currentTime) {
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        if (!$task.getLock().tryLock(1L, TimeUnit.MILLISECONDS)) {
            return;
        }
        if ($task.getExecuting()) {
            $task.getLock().unlock();
            return;
        }
        if (TimeUtil.INSTANCE.millis() - $currentTime >= (long)$task.getMaxDelayTime()) {
            $task.getLock().unlock();
            return;
        }
        try {
            try {
                $task.setThread(Thread.currentThread());
                $task.getRunnable().run();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            $task.setThread(null);
        }
        catch (InterruptedException exception) {
            $task.setThread(null);
        }
        $task.setLastExecution($currentTime);
        $task.getLock().unlock();
    }

    private static final void _init_$lambda$1() {
        while (true) {
            long currentTime = TimeUtil.INSTANCE.millis();
            taskLock.acquire();
            Set toRemove = new LinkedHashSet();
            for (TimeWorkerTask task : TASKS) {
                if (task.getExecuting() || currentTime - task.getLastExecution() <= (long)task.getInterval()) continue;
                DefaultThreadPool.INSTANCE.plusAssign(new ThreadPoolRunnable(task.getExecutionPriority(), false, false, () -> TimeWorker.lambda$1$lambda$0(task, currentTime), 6, null));
                if (!task.getRunOnce()) continue;
                ((Collection)toRemove).add(task);
            }
            taskLock.release();
            if (!((Collection)toRemove).isEmpty()) {
                taskLock.lock();
                CollectionsKt.removeAll((Collection)TASKS, (Iterable)toRemove);
                taskLock.unlock();
            }
            Thread.sleep(1L);
        }
    }

    static {
        new Thread(TimeWorker::_init_$lambda$1, "TimeWorkerThread").start();
    }
}

