/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.thread;

import java.util.Arrays;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lde/bixilon/kutil/concurrent/thread/NamedThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "format", "", "(Ljava/lang/String;)V", "count", "Ljava/util/concurrent/atomic/AtomicInteger;", "getCount", "()Ljava/util/concurrent/atomic/AtomicInteger;", "setCount", "(Ljava/util/concurrent/atomic/AtomicInteger;)V", "getFormat", "()Ljava/lang/String;", "newThread", "Ljava/lang/Thread;", "runnable", "Ljava/lang/Runnable;", "kutil"})
public final class NamedThreadFactory
implements ThreadFactory {
    @NotNull
    private final String format;
    @NotNull
    private AtomicInteger count;

    public NamedThreadFactory(@NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.format = format;
        this.count = new AtomicInteger(0);
    }

    @NotNull
    public final String getFormat() {
        return this.format;
    }

    @NotNull
    public final AtomicInteger getCount() {
        return this.count;
    }

    public final void setCount(@NotNull AtomicInteger atomicInteger) {
        Intrinsics.checkNotNullParameter((Object)atomicInteger, (String)"<set-?>");
        this.count = atomicInteger;
    }

    @Override
    @NotNull
    public Thread newThread(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        String string = this.format;
        Object[] objectArray = new Object[]{this.count.incrementAndGet()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        return new Thread(runnable, string2);
    }
}

