/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.pool;

import de.bixilon.kutil.collections.CollectionUtil;
import de.bixilon.kutil.concurrent.pool.ThreadPoolRunnable;
import de.bixilon.kutil.concurrent.pool.ThreadPoolStates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0016\u0018\u0000 72\u00020\u0001:\u00017B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\rJ\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0016J0\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H%0$0\u0016\"\u0004\b\u0000\u0010%2\u0014\u0010\u001a\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H%0'0&H\u0016J@\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H%0$0\u0016\"\u0004\b\u0000\u0010%2\u0014\u0010\u001a\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H%0'0&2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001dH\u0016J)\u0010)\u001a\u0002H%\"\u0004\b\u0000\u0010%2\u0014\u0010\u001a\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H%0'0&H\u0016\u00a2\u0006\u0002\u0010*J9\u0010)\u001a\u0002H%\"\u0004\b\u0000\u0010%2\u0014\u0010\u001a\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H%0'0&2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010+J\u0006\u0010,\u001a\u00020\u0019J\u0006\u0010-\u001a\u00020\u0019J\b\u0010.\u001a\u00020\u0019H\u0016J\b\u0010/\u001a\u00020\u0019H\u0016J\u0011\u00100\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\rH\u0086\u0002J\u0011\u00100\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0086\u0002J\u0010\u00101\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\rH\u0002J\b\u00102\u001a\u00020\u001fH\u0016J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\"0\u0016H\u0016J\b\u00104\u001a\u00020\u001fH\u0002J\u0014\u00105\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010\u001a\u001a\u00020\"H\u0016J)\u00105\u001a\b\u0012\u0004\u0012\u0002H%0$\"\u0004\b\u0000\u0010%2\u0006\u0010\u001a\u001a\u00020\"2\u0006\u0010\u001c\u001a\u0002H%H\u0016\u00a2\u0006\u0002\u00106J\"\u00105\u001a\b\u0012\u0004\u0012\u0002H%0$\"\u0004\b\u0000\u0010%2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H%0'H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "Ljava/util/concurrent/ExecutorService;", "threadCount", "", "name", "", "priority", "(ILjava/lang/String;I)V", "nextThreadId", "getPriority", "()I", "queue", "Ljava/util/concurrent/PriorityBlockingQueue;", "Lde/bixilon/kutil/concurrent/pool/ThreadPoolRunnable;", "queueSize", "getQueueSize", "running", "Ljava/util/concurrent/atomic/AtomicInteger;", "state", "Lde/bixilon/kutil/concurrent/pool/ThreadPoolStates;", "getThreadCount", "threads", "", "Ljava/lang/Thread;", "awaitTermination", "", "p0", "", "p1", "Ljava/util/concurrent/TimeUnit;", "checkThreads", "", "execute", "runnable", "Ljava/lang/Runnable;", "invokeAll", "Ljava/util/concurrent/Future;", "T", "", "Ljava/util/concurrent/Callable;", "p2", "invokeAny", "(Ljava/util/Collection;)Ljava/lang/Object;", "(Ljava/util/Collection;JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "isBacklog", "isBusy", "isShutdown", "isTerminated", "plusAssign", "run", "shutdown", "shutdownNow", "startThreadLoop", "submit", "(Ljava/lang/Runnable;Ljava/lang/Object;)Ljava/util/concurrent/Future;", "Priorities", "kutil"})
@SourceDebugExtension(value={"SMAP\nThreadPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadPool.kt\nde/bixilon/kutil/concurrent/pool/ThreadPool\n+ 2 CollectionUtil.kt\nde/bixilon/kutil/collections/CollectionUtil\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n54#2:202\n1#3:203\n*S KotlinDebug\n*F\n+ 1 ThreadPool.kt\nde/bixilon/kutil/concurrent/pool/ThreadPool\n*L\n26#1:202\n*E\n"})
public class ThreadPool
implements ExecutorService {
    @NotNull
    public static final Priorities Priorities = new Priorities(null);
    private final int threadCount;
    @NotNull
    private final String name;
    private final int priority;
    @NotNull
    private AtomicInteger running;
    @NotNull
    private ThreadPoolStates state;
    @NotNull
    private List<Thread> threads;
    @NotNull
    private PriorityBlockingQueue<ThreadPoolRunnable> queue;
    private int nextThreadId;
    public static final int HIGHEST = Integer.MAX_VALUE;
    public static final int HIGHER = 500;
    public static final int HIGH = 100;
    public static final int NORMAL = 0;
    public static final int LOW = -100;
    public static final int LOWER = -500;
    public static final int LOWEST = Integer.MIN_VALUE;

    public ThreadPool(int threadCount, @NotNull String name, int priority) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.threadCount = threadCount;
        this.name = name;
        this.priority = priority;
        this.running = new AtomicInteger();
        this.state = ThreadPoolStates.STARTING;
        CollectionUtil collectionUtil = CollectionUtil.INSTANCE;
        Thread[] values$iv = new Thread[]{};
        boolean $i$f$synchronizedListOf = false;
        List list = Collections.synchronizedList(CollectionsKt.mutableListOf((Object[])Arrays.copyOf(values$iv, values$iv.length)));
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(mutableListOf(*values))");
        this.threads = list;
        this.queue = new PriorityBlockingQueue();
        if (!(this.threadCount >= 1)) {
            boolean bl = false;
            String string = "Can not have < 1 thread!";
            throw new IllegalStateException(string.toString());
        }
        this.checkThreads();
        this.state = ThreadPoolStates.STARTED;
    }

    public /* synthetic */ ThreadPool(int n, String string, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = Runtime.getRuntime().availableProcessors();
        }
        if ((n3 & 2) != 0) {
            string = "Worker#%d";
        }
        if ((n3 & 4) != 0) {
            n2 = 1;
        }
        this(n, string, n2);
    }

    public final int getThreadCount() {
        return this.threadCount;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final int getQueueSize() {
        return this.queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void run(ThreadPoolRunnable runnable) {
        try {
            this.running.incrementAndGet();
            runnable.setThread(Thread.currentThread());
            Runnable runnable2 = runnable.getRunnable();
            if (runnable2 != null) {
                runnable2.run();
            }
            runnable.setThread(null);
        }
        catch (InterruptedException exception) {
            runnable.setWasInterrupted(true);
            ((Collection)this.queue).add(runnable);
        }
        catch (Throwable exception) {
            exception.printStackTrace();
        }
        finally {
            runnable.setThread(null);
            this.running.decrementAndGet();
        }
    }

    private final void startThreadLoop() {
        ThreadPoolRunnable runnable = null;
        while (this.state != ThreadPoolStates.STOPPING) {
            try {
                Intrinsics.checkNotNullExpressionValue((Object)this.queue.take(), (String)"queue.take()");
            }
            catch (InterruptedException exception) {
                continue;
            }
            this.run(runnable);
            if (this.state != ThreadPoolStates.STOPPING) continue;
            break;
        }
    }

    private final synchronized void checkThreads() {
        int n = this.threadCount - this.threads.size();
        for (int i = 0; i < n; ++i) {
            Thread thread = new Thread(() -> ThreadPool.checkThreads$lambda$1(this));
            int n2 = this.nextThreadId;
            this.nextThreadId = n2 + 1;
            thread.setName(StringsKt.replace$default((String)this.name, (String)"%d", (String)String.valueOf(n2), (boolean)false, (int)4, null));
            thread.setPriority(this.priority);
            thread.start();
            ((Collection)this.threads).add(thread);
        }
    }

    public final void execute(@NotNull ThreadPoolRunnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        if (!runnable.getForcePool() && (this.isBusy() || this.isBacklog())) {
            this.run(runnable);
            return;
        }
        ((Collection)this.queue).add(runnable);
    }

    @Override
    public void execute(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.execute(new ThreadPoolRunnable(0, false, false, runnable, 7, null));
    }

    public final void plusAssign(@NotNull ThreadPoolRunnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.execute(runnable);
    }

    public final void plusAssign(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.state = ThreadPoolStates.STOPPING;
        List<Thread> list = this.threads;
        synchronized (list) {
            boolean bl = false;
            for (Thread thread : CollectionUtil.INSTANCE.toSynchronizedList((Collection)this.threads)) {
                thread.interrupt();
            }
            Unit unit = Unit.INSTANCE;
        }
        while (!((Collection)this.threads).isEmpty()) {
            Thread.sleep(1L);
        }
        this.state = ThreadPoolStates.STOPPED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        this.state = ThreadPoolStates.STOPPING;
        List<Thread> list = this.threads;
        synchronized (list) {
            boolean bl = false;
            for (Thread thread : CollectionUtil.INSTANCE.toSynchronizedList((Collection)this.threads)) {
                thread.interrupt();
            }
            Unit unit = Unit.INSTANCE;
        }
        this.state = ThreadPoolStates.STOPPED;
        return new ArrayList();
    }

    @Override
    public boolean isShutdown() {
        return this.state == ThreadPoolStates.STOPPING;
    }

    @Override
    public boolean isTerminated() {
        return this.state == ThreadPoolStates.STOPPED;
    }

    @Override
    public boolean awaitTermination(long p0, @NotNull TimeUnit p1) {
        Intrinsics.checkNotNullParameter((Object)((Object)p1), (String)"p1");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> p0) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Runnable p0, T p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> p0) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> p0, long p1, @NotNull TimeUnit p2) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)((Object)p2), (String)"p2");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> p0) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> p0, long p1, @NotNull TimeUnit p2) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)((Object)p2), (String)"p2");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    public final boolean isBusy() {
        return this.running.get() >= this.threads.size();
    }

    public final boolean isBacklog() {
        return this.queue.size() >= this.threads.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void checkThreads$lambda$1(ThreadPool this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            this$0.startThreadLoop();
        }
        catch (Exception exception) {
            this$0.checkThreads();
            throw exception;
        }
        finally {
            ((Collection)this$0.threads).remove(Thread.currentThread());
        }
    }

    public ThreadPool() {
        this(0, null, 0, 7, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/bixilon/kutil/concurrent/pool/ThreadPool$Priorities;", "", "()V", "HIGH", "", "HIGHER", "HIGHEST", "LOW", "LOWER", "LOWEST", "NORMAL", "kutil"})
    public static final class Priorities {
        private Priorities() {
        }

        public /* synthetic */ Priorities(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

