/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.lock.simple;

import de.bixilon.kutil.concurrent.lock.Lock;
import de.bixilon.kutil.concurrent.lock.simple.SimpleLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0001J\b\u0010\u0004\u001a\u00020\u0011H\u0016J\u0011\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0001H\u0086\u0002J\u0011\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0001H\u0086\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0001J\b\u0010\u0018\u001a\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lde/bixilon/kutil/concurrent/lock/simple/ParentLock;", "Lde/bixilon/kutil/concurrent/lock/Lock;", "parents", "", "lock", "(Ljava/util/List;Lde/bixilon/kutil/concurrent/lock/Lock;)V", "getLock", "()Lde/bixilon/kutil/concurrent/lock/Lock;", "locked", "", "getLocked", "()Z", "readers", "", "getReaders", "()I", "acquire", "", "add", "parent", "minusAssign", "plusAssign", "release", "remove", "unlock", "kutil"})
public final class ParentLock
implements Lock {
    @NotNull
    private List<Lock> parents;
    @NotNull
    private final Lock lock;

    public ParentLock(@NotNull List<Lock> parents, @NotNull Lock lock) {
        Intrinsics.checkNotNullParameter(parents, (String)"parents");
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        this.parents = parents;
        this.lock = lock;
    }

    public /* synthetic */ ParentLock(List list, Lock lock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = new ArrayList();
        }
        if ((n & 2) != 0) {
            lock = new SimpleLock();
        }
        this(list, lock);
    }

    @NotNull
    public final Lock getLock() {
        return this.lock;
    }

    public final void add(@NotNull Lock parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.lock.lock();
        ((Collection)this.parents).add(parent);
        this.lock.unlock();
    }

    public final void plusAssign(@NotNull Lock parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.add(parent);
    }

    public final void remove(@NotNull Lock parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.lock.lock();
        ((Collection)this.parents).remove(parent);
        this.lock.unlock();
    }

    public final void minusAssign(@NotNull Lock parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.remove(parent);
    }

    @Override
    public int getReaders() {
        return this.lock.getReaders();
    }

    @Override
    public boolean getLocked() {
        return this.lock.getLocked();
    }

    @Override
    public void acquire() {
        this.lock.acquire();
        for (Lock parent : this.parents) {
            parent.acquire();
        }
    }

    @Override
    public void release() {
        this.lock.release();
        for (Lock parent : this.parents) {
            parent.release();
        }
    }

    @Override
    public void lock() {
        this.lock.lock();
        for (Lock parent : this.parents) {
            parent.lock();
        }
    }

    @Override
    public void unlock() {
        this.lock.unlock();
        for (Lock parent : this.parents) {
            parent.unlock();
        }
    }

    public ParentLock() {
        this(null, null, 3, null);
    }
}

