/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.buffer.bytes.in;

import de.bixilon.kutil.buffer.bytes.in.ByteBufferUnderflowException;
import de.bixilon.kutil.uuid.UUIDUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0017\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0011\u001a\u00020\u0012J7\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0014\"\u0006\b\u0000\u0010\u0015\u0018\u00012\b\b\u0002\u0010\u0016\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0018H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003H\u0016J\u0012\u0010\u001e\u001a\u00020\u00032\b\b\u0002\u0010\u0016\u001a\u00020\bH\u0016J\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020$2\b\b\u0002\u0010\u0016\u001a\u00020\bJ\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u00020(2\b\b\u0002\u0010\u0016\u001a\u00020\bJ\u0006\u0010)\u001a\u00020\bJ\u0010\u0010*\u001a\u00020+2\b\b\u0002\u0010\u0016\u001a\u00020\bJ\u0006\u0010,\u001a\u00020-J\u0010\u0010.\u001a\u00020/2\b\b\u0002\u0010\u0016\u001a\u00020\bJ\u0018\u0010.\u001a\u00020\u001f2\u0006\u00100\u001a\u00020/2\b\b\u0002\u0010\u000f\u001a\u00020\bJ\u0012\u00101\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0016\u001a\u00020\bJ,\u00102\u001a\u0004\u0018\u0001H\u0015\"\u0004\b\u0000\u0010\u00152\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H\u001503\u00a2\u0006\u0002\b4\u00a2\u0006\u0002\u00105J\u0006\u00106\u001a\u00020\u0003J\u0006\u00107\u001a\u000208J\u0010\u00109\u001a\u00020:2\b\b\u0002\u0010\u0016\u001a\u00020\bJ\u0010\u0010;\u001a\u00020\u00122\b\b\u0002\u0010\u0016\u001a\u00020\bJ\u0006\u0010<\u001a\u00020=J\u0006\u0010>\u001a\u00020=J\u0006\u0010?\u001a\u00020\bJ\u0006\u0010@\u001a\u00020-J\u0006\u0010A\u001a\u00020\bJ\u0006\u0010B\u001a\u00020-J\u0006\u0010C\u001a\u00020\bJ\u0012\u0010D\u001a\u00020+2\b\b\u0002\u0010\u0016\u001a\u00020\bH\u0007J\u0006\u0010E\u001a\u00020-J\u0010\u0010F\u001a\u00020/2\b\b\u0002\u0010\u0016\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\n\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\n\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006G"}, d2={"Lde/bixilon/kutil/buffer/bytes/in/InByteBuffer;", "", "bytes", "", "([B)V", "buffer", "(Lde/bixilon/kutil/buffer/bytes/in/InByteBuffer;)V", "bytesLeft", "", "getBytesLeft", "()I", "pointer", "getPointer", "setPointer", "(I)V", "size", "getSize", "getBase64", "", "readArray", "", "T", "length", "reader", "Lkotlin/Function0;", "(ILkotlin/jvm/functions/Function0;)[Ljava/lang/Object;", "readBoolean", "", "readByte", "", "readByteArray", "", "array", "readDouble", "", "readDoubleArray", "", "readFloat", "", "readFloatArray", "", "readInt", "readIntArray", "", "readLong", "", "readLongArray", "", "target", "readNullString", "readOptional", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "readRest", "readShort", "", "readShortArray", "", "readString", "readUUID", "Ljava/util/UUID;", "readUUIDString", "readUnsignedByte", "readUnsignedInt", "readUnsignedShort", "readUnsignedVarInt", "readVarInt", "readVarIntArray", "readVarLong", "readVarLongArray", "kutil"})
@SourceDebugExtension(value={"SMAP\nInByteBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InByteBuffer.kt\nde/bixilon/kutil/buffer/bytes/in/InByteBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,247:1\n1#2:248\n37#3,2:249\n*S KotlinDebug\n*F\n+ 1 InByteBuffer.kt\nde/bixilon/kutil/buffer/bytes/in/InByteBuffer\n*L\n43#1:249,2\n*E\n"})
public class InByteBuffer {
    @NotNull
    private final byte[] bytes;
    private int pointer;

    public final int getPointer() {
        return this.pointer;
    }

    public final void setPointer(int n) {
        this.pointer = n;
    }

    public InByteBuffer(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.bytes = bytes;
    }

    public InByteBuffer(@NotNull InByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.bytes = (byte[])buffer.bytes.clone();
        this.pointer = buffer.pointer;
    }

    public final int getSize() {
        return this.bytes.length;
    }

    public final int getBytesLeft() {
        return this.getSize() - this.pointer;
    }

    public final /* synthetic */ <T> T[] readArray(int length, Function0<? extends T> reader) {
        Intrinsics.checkNotNullParameter(reader, (String)"reader");
        boolean $i$f$readArray = false;
        if (!(length <= this.getSize())) {
            boolean $i$a$-check-InByteBuffer$readArray$22 = false;
            String $i$a$-check-InByteBuffer$readArray$22 = "Trying to allocate too much memory!";
            throw new IllegalStateException($i$a$-check-InByteBuffer$readArray$22.toString());
        }
        List array = new ArrayList();
        for (int i = 0; i < length; ++i) {
            array.add(i, reader.invoke());
        }
        Collection $this$toTypedArray$iv = array;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
        return thisCollection$iv.toArray(new Object[0]);
    }

    public static /* synthetic */ Object[] readArray$default(InByteBuffer $this, int length, Function0 reader, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readArray");
        }
        if ((n & 1) != 0) {
            length = $this.readVarInt();
        }
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        boolean $i$f$readArray = false;
        if (!(length <= $this.getSize())) {
            boolean $i$a$-check-InByteBuffer$readArray$22 = false;
            String $i$a$-check-InByteBuffer$readArray$22 = "Trying to allocate too much memory!";
            throw new IllegalStateException($i$a$-check-InByteBuffer$readArray$22.toString());
        }
        List array = new ArrayList();
        for (int i = 0; i < length; ++i) {
            array.add(i, reader.invoke());
        }
        Collection $this$toTypedArray$iv = array;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
        return thisCollection$iv.toArray(new Object[0]);
    }

    public final byte readByte() {
        if (this.pointer >= this.getSize()) {
            throw new ByteBufferUnderflowException(this.pointer, this.getSize());
        }
        int n = this.pointer;
        this.pointer = n + 1;
        return this.bytes[n];
    }

    public void readByteArray(@NotNull byte[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        System.arraycopy(this.bytes, this.pointer, array, 0, array.length);
        this.pointer += array.length;
    }

    @NotNull
    public byte[] readByteArray(int length) {
        if (!(length <= this.bytes.length)) {
            boolean bl = false;
            String string = "Trying to allocate too much memory!";
            throw new IllegalStateException(string.toString());
        }
        byte[] array = new byte[length];
        System.arraycopy(this.bytes, this.pointer, array, 0, length);
        this.pointer += length;
        return array;
    }

    public static /* synthetic */ byte[] readByteArray$default(InByteBuffer inByteBuffer, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readByteArray");
        }
        if ((n2 & 1) != 0) {
            n = inByteBuffer.readVarInt();
        }
        return inByteBuffer.readByteArray(n);
    }

    public final int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    public final short readShort() {
        return (short)(this.readUnsignedByte() << 8 | this.readUnsignedByte());
    }

    @NotNull
    public final short[] readShortArray(int length) {
        if (!(length <= this.bytes.length / 2)) {
            boolean $i$a$-check-InByteBuffer$readShortArray$22 = false;
            String $i$a$-check-InByteBuffer$readShortArray$22 = "Trying to allocate too much memory!";
            throw new IllegalStateException($i$a$-check-InByteBuffer$readShortArray$22.toString());
        }
        short[] array = new short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readShort();
        }
        return array;
    }

    public static /* synthetic */ short[] readShortArray$default(InByteBuffer inByteBuffer, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readShortArray");
        }
        if ((n2 & 1) != 0) {
            n = inByteBuffer.readVarInt();
        }
        return inByteBuffer.readShortArray(n);
    }

    public final int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    public final int readInt() {
        return this.readUnsignedShort() << 16 | this.readUnsignedShort();
    }

    @NotNull
    public final int[] readIntArray(int length) {
        if (!(length <= this.bytes.length / 4)) {
            boolean $i$a$-check-InByteBuffer$readIntArray$22 = false;
            String $i$a$-check-InByteBuffer$readIntArray$22 = "Trying to allocate too much memory!";
            throw new IllegalStateException($i$a$-check-InByteBuffer$readIntArray$22.toString());
        }
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readInt();
        }
        return array;
    }

    public static /* synthetic */ int[] readIntArray$default(InByteBuffer inByteBuffer, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readIntArray");
        }
        if ((n2 & 1) != 0) {
            n = inByteBuffer.readVarInt();
        }
        return inByteBuffer.readIntArray(n);
    }

    public final long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public final int readVarInt() {
        int byteCount = 0;
        int result = 0;
        int read = 0;
        do {
            read = this.readUnsignedByte();
            result |= (read & 0x7F) << 7 * byteCount;
            if (++byteCount <= 5) continue;
            boolean bl = false;
            String string = "VarInt is too big";
            throw new IllegalArgumentException(string.toString());
        } while ((read & 0x80) != 0);
        return result;
    }

    @JvmOverloads
    @NotNull
    public final int[] readVarIntArray(int length) {
        if (!(length <= this.bytes.length)) {
            boolean $i$a$-check-InByteBuffer$readVarIntArray$22 = false;
            String $i$a$-check-InByteBuffer$readVarIntArray$22 = "Trying to allocate too much memory!";
            throw new IllegalStateException($i$a$-check-InByteBuffer$readVarIntArray$22.toString());
        }
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readVarInt();
        }
        return array;
    }

    public static /* synthetic */ int[] readVarIntArray$default(InByteBuffer inByteBuffer, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readVarIntArray");
        }
        if ((n2 & 1) != 0) {
            n = inByteBuffer.readVarInt();
        }
        return inByteBuffer.readVarIntArray(n);
    }

    public final long readUnsignedVarInt() {
        return (long)this.readVarInt() & 0L;
    }

    public final long readLong() {
        return this.readUnsignedInt() << 32 | this.readUnsignedInt();
    }

    @NotNull
    public final long[] readLongArray(int length) {
        if (!(length <= this.bytes.length / 8)) {
            boolean $i$a$-check-InByteBuffer$readLongArray$22 = false;
            String $i$a$-check-InByteBuffer$readLongArray$22 = "Trying to allocate too much memory!";
            throw new IllegalStateException($i$a$-check-InByteBuffer$readLongArray$22.toString());
        }
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readLong();
        }
        return array;
    }

    public static /* synthetic */ long[] readLongArray$default(InByteBuffer inByteBuffer, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readLongArray");
        }
        if ((n2 & 1) != 0) {
            n = inByteBuffer.readVarInt();
        }
        return inByteBuffer.readLongArray(n);
    }

    public final void readLongArray(@NotNull long[] target, int size) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        for (int i = 0; i < size; ++i) {
            target[i] = this.readLong();
        }
    }

    public static /* synthetic */ void readLongArray$default(InByteBuffer inByteBuffer, long[] lArray, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readLongArray");
        }
        if ((n2 & 2) != 0) {
            n = inByteBuffer.readVarInt();
        }
        inByteBuffer.readLongArray(lArray, n);
    }

    public final long readVarLong() {
        int byteCount = 0;
        long result = 0L;
        int read = 0;
        do {
            read = this.readUnsignedByte();
            result |= (long)((read & 0x7F) << 7 * byteCount);
            if (++byteCount <= 9) continue;
            boolean bl = false;
            String string = "VarLong is too big";
            throw new IllegalArgumentException(string.toString());
        } while ((read & 0x80) != 0);
        return result;
    }

    @NotNull
    public final long[] readVarLongArray(int length) {
        if (!(length <= this.bytes.length)) {
            boolean $i$a$-check-InByteBuffer$readVarLongArray$22 = false;
            String $i$a$-check-InByteBuffer$readVarLongArray$22 = "Trying to allocate too much memory!";
            throw new IllegalStateException($i$a$-check-InByteBuffer$readVarLongArray$22.toString());
        }
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readVarLong();
        }
        return array;
    }

    public static /* synthetic */ long[] readVarLongArray$default(InByteBuffer inByteBuffer, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readVarLongArray");
        }
        if ((n2 & 1) != 0) {
            n = inByteBuffer.readVarInt();
        }
        return inByteBuffer.readVarLongArray(n);
    }

    public final float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @NotNull
    public final float[] readFloatArray(int length) {
        if (!(length <= this.bytes.length / 4)) {
            boolean $i$a$-check-InByteBuffer$readFloatArray$22 = false;
            String $i$a$-check-InByteBuffer$readFloatArray$22 = "Trying to allocate too much memory!";
            throw new IllegalStateException($i$a$-check-InByteBuffer$readFloatArray$22.toString());
        }
        float[] array = new float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readFloat();
        }
        return array;
    }

    public static /* synthetic */ float[] readFloatArray$default(InByteBuffer inByteBuffer, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readFloatArray");
        }
        if ((n2 & 1) != 0) {
            n = inByteBuffer.readVarInt();
        }
        return inByteBuffer.readFloatArray(n);
    }

    public final double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @NotNull
    public final double[] readDoubleArray(int length) {
        if (!(length <= this.bytes.length / 8)) {
            boolean $i$a$-check-InByteBuffer$readDoubleArray$22 = false;
            String $i$a$-check-InByteBuffer$readDoubleArray$22 = "Trying to allocate too much memory!";
            throw new IllegalStateException($i$a$-check-InByteBuffer$readDoubleArray$22.toString());
        }
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readDouble();
        }
        return array;
    }

    public static /* synthetic */ double[] readDoubleArray$default(InByteBuffer inByteBuffer, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readDoubleArray");
        }
        if ((n2 & 1) != 0) {
            n = inByteBuffer.readVarInt();
        }
        return inByteBuffer.readDoubleArray(n);
    }

    public final boolean readBoolean() {
        return this.readUnsignedByte() == 1;
    }

    @NotNull
    public final String readString(int length) {
        byte[] byArray = this.readByteArray(length);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return new String(byArray, charset2);
    }

    public static /* synthetic */ String readString$default(InByteBuffer inByteBuffer, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readString");
        }
        if ((n2 & 1) != 0) {
            n = inByteBuffer.readVarInt();
        }
        return inByteBuffer.readString(n);
    }

    @Nullable
    public final String readNullString(int length) {
        String string = this.readString(length);
        if (StringsKt.isBlank((CharSequence)string)) {
            return null;
        }
        return string;
    }

    public static /* synthetic */ String readNullString$default(InByteBuffer inByteBuffer, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readNullString");
        }
        if ((n2 & 1) != 0) {
            n = inByteBuffer.readVarInt();
        }
        return inByteBuffer.readNullString(n);
    }

    @NotNull
    public final UUID readUUID() {
        return new UUID(this.readLong(), this.readLong());
    }

    @NotNull
    public final UUID readUUIDString() {
        return UUIDUtil.INSTANCE.toUUID(InByteBuffer.readString$default(this, 0, 1, null));
    }

    @NotNull
    public final byte[] readRest() {
        return this.readByteArray(this.getSize() - this.pointer);
    }

    @NotNull
    public final String getBase64() {
        byte[] byArray = Base64.getEncoder().encode(this.readRest());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoder().encode(readRest())");
        byte[] byArray2 = byArray;
        return new String(byArray2, Charsets.UTF_8);
    }

    @Nullable
    public final <T> T readOptional(@NotNull Function1<? super InByteBuffer, ? extends T> reader) {
        Intrinsics.checkNotNullParameter(reader, (String)"reader");
        return (T)(this.readBoolean() ? reader.invoke((Object)this) : null);
    }

    @JvmOverloads
    @NotNull
    public final int[] readVarIntArray() {
        return InByteBuffer.readVarIntArray$default(this, 0, 1, null);
    }
}

