package de.bixilon.kutil.math

import kotlin.math.PI

object Trigonometry {
    private const val VALUES = 65535
    private const val MASK = 0xFFFF
    private val SINE_TABLE = FloatArray(65536) { kotlin.math.sin(it * PI * 2.0 / VALUES).toFloat() }

    fun sin(value: Float): Float {
        return SINE_TABLE[(value * 10430.378f).toInt() and MASK]
    }

    fun cos(value: Float): Float {
        return SINE_TABLE[(value * 10430.378f + (VALUES / 4)).toInt() and MASK]
    }
}
