/*
 * KUtil
 * Copyright (C) 2021-2022 Moritz Zwerger
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

package de.bixilon.kutil.array

object IntArrayUtil {
    val EMPTY = intArrayOf()

    inline fun IntArray.getOrElse(index: Int, `else`: Int): Int {
        if (index < 0 || index >= this.size) {
            return `else`
        }
        return this[index]
    }

    inline fun IntArray.isIndex(index: Int): Boolean {
        return index > 0 && index < size
    }
}
