/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.watcher.list;

import de.bixilon.kutil.watcher.list.ListChange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.markers.KMutableList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016J\u0016\u0010\u0017\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016J \u0010\u001a\u001a\u00020\u00102\u0018\u0010\u001b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f\u0012\u0004\u0012\u00020\u00100\u000eJ\b\u0010\u001c\u001a\u00020\u0010H\u0016J\u0016\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u001e\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016J\u0013\u0010\u001f\u001a\u00020\u00122\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\u0016\u0010\"\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0006H\u0096\u0002\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020\u0006H\u0016J\u0015\u0010%\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020\u0012H\u0016J\u000f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)H\u0096\u0002J\u0015\u0010*\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010&J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000,H\u0016J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000,2\u0006\u0010\u0015\u001a\u00020\u0006H\u0016J\u0016\u0010-\u001a\u00020\u00102\f\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0002J\u0015\u0010/\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0016\u00100\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016J\u0015\u00101\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010#J\u0016\u00102\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016J\u001e\u00103\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u00104J\u001e\u00105\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u0006H\u0016J\b\u00108\u001a\u000209H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068VX\u0096\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\t\u0010\n*\u0004\b\u0007\u0010\bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR&\u0010\r\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lde/bixilon/kutil/watcher/list/ObservedList;", "V", "", "unsafe", "(Ljava/util/List;)V", "size", "", "getSize$delegate", "(Lde/bixilon/kutil/watcher/list/ObservedList;)Ljava/lang/Object;", "getSize", "()I", "getUnsafe", "()Ljava/util/List;", "watchers", "Lkotlin/Function1;", "Lde/bixilon/kutil/watcher/list/ListChange;", "", "add", "", "element", "(Ljava/lang/Object;)Z", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "addWatcher", "watcher", "clear", "contains", "containsAll", "equals", "other", "", "get", "(I)Ljava/lang/Object;", "hashCode", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "notifyWatchers", "change", "remove", "removeAll", "removeAt", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "subList", "fromIndex", "toIndex", "toString", "", "kutil"})
public final class ObservedList<V>
implements List<V>,
KMutableList {
    @NotNull
    private final List<V> unsafe;
    @NotNull
    private final List<Function1<ListChange<V>, Unit>> watchers;

    public ObservedList(@NotNull List<V> unsafe) {
        Intrinsics.checkNotNullParameter(unsafe, (String)"unsafe");
        this.unsafe = unsafe;
        this.watchers = new ArrayList();
    }

    @NotNull
    public final List<V> getUnsafe() {
        return this.unsafe;
    }

    public int getSize() {
        return this.unsafe.size();
    }

    public static Object getSize$delegate(ObservedList<Object> observedList) {
        Intrinsics.checkNotNullParameter(observedList, (String)"<this>");
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl(observedList.unsafe, List.class, "size", "size()I", 0)));
    }

    public final void addWatcher(@NotNull Function1<? super ListChange<V>, Unit> watcher) {
        Intrinsics.checkNotNullParameter(watcher, (String)"watcher");
        ((Collection)this.watchers).add(watcher);
    }

    private final void notifyWatchers(ListChange<V> change) {
        for (Function1<ListChange<V>, Unit> watcher : this.watchers) {
            watcher.invoke(change);
        }
    }

    @Override
    public boolean contains(Object element) {
        return this.unsafe.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.unsafe.containsAll(elements);
    }

    @Override
    public V get(int index) {
        return this.unsafe.get(index);
    }

    @Override
    public int indexOf(Object element) {
        return this.unsafe.indexOf(element);
    }

    @Override
    public boolean isEmpty() {
        return this.unsafe.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        return this.unsafe.iterator();
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.unsafe.lastIndexOf(element);
    }

    @Override
    public boolean add(V element) {
        this.notifyWatchers(new ListChange(CollectionsKt.listOf(element), CollectionsKt.emptyList()));
        return this.unsafe.add(element);
    }

    @Override
    public void add(int index, V element) {
        this.notifyWatchers(new ListChange(CollectionsKt.listOf(element), CollectionsKt.emptyList()));
        this.unsafe.add(index, element);
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends V> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.notifyWatchers(new ListChange<V>(elements, CollectionsKt.emptyList()));
        return this.unsafe.addAll(index, elements);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends V> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.notifyWatchers(new ListChange<V>(elements, CollectionsKt.emptyList()));
        return this.unsafe.addAll(elements);
    }

    @Override
    public void clear() {
        this.notifyWatchers(new ListChange(CollectionsKt.emptyList(), CollectionsKt.toList((Iterable)this.unsafe)));
        this.unsafe.clear();
    }

    @Override
    @NotNull
    public ListIterator<V> listIterator() {
        return this.unsafe.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<V> listIterator(int index) {
        return this.unsafe.listIterator(index);
    }

    @Override
    public boolean remove(Object element) {
        if (!this.unsafe.remove(element)) {
            return false;
        }
        this.notifyWatchers(new ListChange(CollectionsKt.emptyList(), CollectionsKt.listOf((Object)element)));
        return true;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        List contained = new ArrayList();
        for (Object object : elements) {
            if (!this.unsafe.contains(object)) continue;
            ((Collection)contained).add(object);
        }
        if (!this.unsafe.removeAll(elements)) {
            return false;
        }
        if (!((Collection)contained).isEmpty()) {
            this.notifyWatchers(new ListChange(CollectionsKt.emptyList(), contained));
        }
        return true;
    }

    public V removeAt(int index) {
        V removed = this.unsafe.remove(index);
        this.notifyWatchers(new ListChange(CollectionsKt.emptyList(), CollectionsKt.listOf(removed)));
        return removed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean removed = this.unsafe.retainAll(elements);
        this.notifyWatchers(new ListChange<Object>(CollectionsKt.emptyList(), elements));
        return removed;
    }

    @Override
    public V set(int index, V element) {
        V previous = this.unsafe.set(index, element);
        this.notifyWatchers(new ListChange(CollectionsKt.listOf(element), CollectionsKt.listOf(element)));
        return previous;
    }

    @Override
    @NotNull
    public List<V> subList(int fromIndex, int toIndex) {
        return this.unsafe.subList(fromIndex, toIndex);
    }

    @NotNull
    public String toString() {
        return this.unsafe.toString();
    }

    @Override
    public int hashCode() {
        return ((Object)this.unsafe).hashCode();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return Intrinsics.areEqual(this.unsafe, (Object)other);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

