/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.unit;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u000fJ\f\u0010\u0010\u001a\u00020\u0007*\u00020\u0004H\u0002J\n\u0010\u0011\u001a\u00020\u0007*\u00020\u0012J\n\u0010\u0011\u001a\u00020\u0007*\u00020\u0004J\n\u0010\u0013\u001a\u00020\u0007*\u00020\u0012J\n\u0010\u0013\u001a\u00020\u0007*\u00020\u0004J\n\u0010\u0014\u001a\u00020\u0007*\u00020\u0012J\n\u0010\u0014\u001a\u00020\u0007*\u00020\u0004J\n\u0010\u0015\u001a\u00020\u0007*\u00020\u0012J\n\u0010\u0015\u001a\u00020\u0007*\u00020\u0004J\n\u0010\u0016\u001a\u00020\u0007*\u00020\u0012J\n\u0010\u0016\u001a\u00020\u0007*\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0017"}, d2={"Lde/bixilon/kutil/unit/UnitFormatter;", "", "()V", "BYTE_FACTOR", "", "BYTE_UNITS", "", "", "[Ljava/lang/String;", "FRACTIONAL_TIME_UNITS", "SI_PREFIXES", "formatUnit", "number", "units", "factor", "(J[Ljava/lang/String;J)Ljava/lang/String;", "_formatNanos", "formatBytes", "", "formatMillis", "formatNanos", "formatSI", "formatSeconds", "kutil"})
public final class UnitFormatter {
    @NotNull
    public static final UnitFormatter INSTANCE = new UnitFormatter();
    private static final long BYTE_FACTOR = 1024L;
    @NotNull
    private static final String[] BYTE_UNITS;
    @NotNull
    private static final String[] SI_PREFIXES;
    @NotNull
    private static final String[] FRACTIONAL_TIME_UNITS;

    private UnitFormatter() {
    }

    @NotNull
    public final String formatBytes(long $this$formatBytes) {
        if ($this$formatBytes < 0L) {
            return "?";
        }
        if ($this$formatBytes < 1024L) {
            return $this$formatBytes + "B";
        }
        return this.formatUnit($this$formatBytes, BYTE_UNITS, 1024L);
    }

    @NotNull
    public final String formatBytes(int $this$formatBytes) {
        return this.formatBytes((long)$this$formatBytes);
    }

    @NotNull
    public final String formatSI(long $this$formatSI) {
        return this.formatUnit($this$formatSI, SI_PREFIXES, 1000L);
    }

    @NotNull
    public final String formatSI(int $this$formatSI) {
        return this.formatSI((long)$this$formatSI);
    }

    private final String formatUnit(long number, String[] units, long factor) {
        long currentFactor = 1L;
        for (String unit : units) {
            long fractionalFactor = currentFactor * (long)10;
            if (number < fractionalFactor) {
                long nonFractional = number / currentFactor;
                long fractional = (number - nonFractional * currentFactor) * (long)10 / currentFactor;
                return nonFractional + "." + fractional + " " + unit;
            }
            long nextFactor = currentFactor * factor;
            if (number < nextFactor) {
                return number / currentFactor + " " + unit;
            }
            currentFactor = nextFactor;
        }
        return String.valueOf(number);
    }

    private final String _formatNanos(long $this$_formatNanos) {
        long currentFactor = 1L;
        String[] stringArray = FRACTIONAL_TIME_UNITS;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            String unit = stringArray[i];
            long fractionalFactor = currentFactor * (long)10;
            if ($this$_formatNanos < fractionalFactor) {
                long nonFractional = $this$_formatNanos / currentFactor;
                long fractional = ($this$_formatNanos - nonFractional * currentFactor) * (long)10 / currentFactor;
                return nonFractional + "." + fractional + " " + unit;
            }
            long nextFactor = currentFactor * (long)1000;
            if (index != 3 && $this$_formatNanos < nextFactor) {
                return $this$_formatNanos / currentFactor + " " + unit;
            }
            currentFactor = nextFactor;
        }
        long seconds = $this$_formatNanos / (long)1000000000;
        if (seconds < 60L) {
            return seconds + " s";
        }
        if (seconds < 3600L) {
            return seconds / (long)60 + " m";
        }
        if (seconds < 86400L) {
            return seconds / (long)3600 + " h";
        }
        long days = seconds / (long)86400;
        if (days < 7L) {
            return days + " d";
        }
        if (days < 30L) {
            return days / (long)7 + " w";
        }
        if (days < 365L) {
            return days / (long)30 + " M";
        }
        return days / (long)365 + " y";
    }

    @NotNull
    public final String formatNanos(long $this$formatNanos) {
        if ($this$formatNanos < 0L) {
            return "-" + this._formatNanos(Math.abs($this$formatNanos));
        }
        return this._formatNanos($this$formatNanos);
    }

    @NotNull
    public final String formatNanos(int $this$formatNanos) {
        return this.formatNanos((long)$this$formatNanos);
    }

    @NotNull
    public final String formatMillis(long $this$formatMillis) {
        return this.formatNanos($this$formatMillis * 1000000L);
    }

    @NotNull
    public final String formatMillis(int $this$formatMillis) {
        return this.formatMillis((long)$this$formatMillis);
    }

    @NotNull
    public final String formatSeconds(long $this$formatSeconds) {
        return this.formatNanos($this$formatSeconds * 1000000000L);
    }

    @NotNull
    public final String formatSeconds(int $this$formatSeconds) {
        return this.formatSeconds((long)$this$formatSeconds);
    }

    static {
        String[] stringArray = new String[]{"B", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB", "ZiB", "YiB"};
        BYTE_UNITS = stringArray;
        stringArray = new String[]{"", "k", "M", "G", "T", "P", "E", "Z", "Y"};
        SI_PREFIXES = stringArray;
        stringArray = new String[]{"ns", "\u00b5s", "ms", "s"};
        FRACTIONAL_TIME_UNITS = stringArray;
    }
}

