/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.string;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.PrimitiveIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000eJ?\u0010\u000f\u001a\u00020\f*\u00020\f2.\u0010\u0010\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00120\u0011\"\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J \u0010\u000f\u001a\u00020\f*\u00020\f2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0014J\u001a\u0010\u0015\u001a\u00020\f*\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\fJ\n\u0010\u0018\u001a\u00020\u0019*\u00020\fJ\n\u0010\u001a\u001a\u00020\u0019*\u00020\fJ\n\u0010\u001b\u001a\u00020\f*\u00020\fJ\u0012\u0010\u001c\u001a\u00020\f*\u00020\f2\u0006\u0010\u001d\u001a\u00020\u000bR\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/bixilon/kutil/string/StringUtil;", "", "()V", "DEFAULT_CHARSET", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "getDEFAULT_CHARSET", "()Ljava/nio/charset/Charset;", "SNAKE_CASE_REGEX", "Lkotlin/text/Regex;", "codePointAtOrNull", "", "", "index", "(Ljava/lang/String;I)Ljava/lang/Integer;", "formatPlaceholder", "format", "", "Lkotlin/Pair;", "(Ljava/lang/String;[Lkotlin/Pair;)Ljava/lang/String;", "", "getBetween", "first", "second", "isLowercase", "", "isUppercase", "toSnakeCase", "truncate", "length", "kutil"})
public final class StringUtil {
    @NotNull
    public static final StringUtil INSTANCE = new StringUtil();
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    @NotNull
    private static final Regex SNAKE_CASE_REGEX = new Regex("(.)(\\p{Upper})");

    private StringUtil() {
    }

    public final Charset getDEFAULT_CHARSET() {
        return DEFAULT_CHARSET;
    }

    @NotNull
    public final String toSnakeCase(@NotNull String $this$toSnakeCase) {
        Intrinsics.checkNotNullParameter((Object)$this$toSnakeCase, (String)"<this>");
        CharSequence charSequence = $this$toSnakeCase;
        Regex regex = SNAKE_CASE_REGEX;
        String string = "$1_$2";
        String string2 = regex.replace(charSequence, string).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return string2;
    }

    public final boolean isLowercase(@NotNull String $this$isLowercase) {
        Intrinsics.checkNotNullParameter((Object)$this$isLowercase, (String)"<this>");
        PrimitiveIterator.OfInt ofInt = $this$isLowercase.codePoints().iterator();
        while (ofInt.hasNext()) {
            Integer code = ofInt.next();
            Intrinsics.checkNotNullExpressionValue((Object)code, (String)"code");
            if (!Character.isUpperCase(code)) continue;
            return false;
        }
        return true;
    }

    public final boolean isUppercase(@NotNull String $this$isUppercase) {
        Intrinsics.checkNotNullParameter((Object)$this$isUppercase, (String)"<this>");
        PrimitiveIterator.OfInt ofInt = $this$isUppercase.codePoints().iterator();
        while (ofInt.hasNext()) {
            Integer code = ofInt.next();
            Intrinsics.checkNotNullExpressionValue((Object)code, (String)"code");
            if (!Character.isLowerCase(code)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final String formatPlaceholder(@NotNull String $this$formatPlaceholder, @NotNull Map<String, ? extends Object> format) {
        Intrinsics.checkNotNullParameter((Object)$this$formatPlaceholder, (String)"<this>");
        Intrinsics.checkNotNullParameter(format, (String)"format");
        String output = $this$formatPlaceholder;
        for (Map.Entry<String, ? extends Object> entry : format.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            output = StringsKt.replace$default((String)output, (String)("${" + key + "}"), (String)String.valueOf(value), (boolean)false, (int)4, null);
        }
        return output;
    }

    @NotNull
    public final String formatPlaceholder(@NotNull String $this$formatPlaceholder, Pair<String, ? extends Object> ... format) {
        Intrinsics.checkNotNullParameter((Object)$this$formatPlaceholder, (String)"<this>");
        Intrinsics.checkNotNullParameter(format, (String)"format");
        String output = $this$formatPlaceholder;
        for (Pair<String, ? extends Object> pair : format) {
            String key = (String)pair.component1();
            Object value = pair.component2();
            output = StringsKt.replace$default((String)output, (String)("${" + key + "}"), (String)String.valueOf(value), (boolean)false, (int)4, null);
        }
        return output;
    }

    @NotNull
    public final String getBetween(@NotNull String $this$getBetween, @NotNull String first, @NotNull String second) {
        Intrinsics.checkNotNullParameter((Object)$this$getBetween, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        String string = $this$getBetween.substring(StringsKt.indexOf$default((CharSequence)$this$getBetween, (String)first, (int)0, (boolean)false, (int)6, null) + first.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        String result = string;
        String string2 = result.substring(0, StringsKt.indexOf$default((CharSequence)result, (String)second, (int)0, (boolean)false, (int)6, null));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string2;
    }

    @Nullable
    public final Integer codePointAtOrNull(@NotNull String $this$codePointAtOrNull, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$codePointAtOrNull, (String)"<this>");
        if (index < 0 || index >= $this$codePointAtOrNull.length()) {
            return null;
        }
        return $this$codePointAtOrNull.codePointAt(index);
    }

    @NotNull
    public final String truncate(@NotNull String $this$truncate, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$truncate, (String)"<this>");
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be < 0: " + length);
        }
        if ($this$truncate.length() <= length) {
            return $this$truncate;
        }
        String string = $this$truncate.substring(0, length);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }
}

