/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.worker;

import de.bixilon.kutil.collections.CollectionUtil;
import de.bixilon.kutil.concurrent.lock.simple.SimpleLock;
import de.bixilon.kutil.concurrent.pool.DefaultThreadPool;
import de.bixilon.kutil.concurrent.pool.ThreadPoolRunnable;
import de.bixilon.kutil.concurrent.worker.TaskWorkerStates;
import de.bixilon.kutil.concurrent.worker.tasks.Task;
import de.bixilon.kutil.latch.CountUpAndDownLatch;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001By\u00128\b\u0002\u0010\u0002\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003\u00128\b\u0002\u0010\u000b\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\u001c\u001a\u00020\n2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\n0\u001eH\u0086\u0002J\u0011\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0004H\u0086\u0002J\u0010\u0010 \u001a\u00020\n2\b\b\u0002\u0010!\u001a\u00020\u001fRJ\u0010\u000b\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010RJ\u0010\u0002\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00040\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lde/bixilon/kutil/concurrent/worker/TaskWorker;", "", "errorHandler", "Lkotlin/Function2;", "Lde/bixilon/kutil/concurrent/worker/tasks/Task;", "Lkotlin/ParameterName;", "name", "task", "", "exception", "", "criticalErrorHandler", "(Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "getCriticalErrorHandler", "()Lkotlin/jvm/functions/Function2;", "setCriticalErrorHandler", "(Lkotlin/jvm/functions/Function2;)V", "getErrorHandler", "setErrorHandler", "otherTodo", "", "<set-?>", "Lde/bixilon/kutil/concurrent/worker/TaskWorkerStates;", "state", "getState", "()Lde/bixilon/kutil/concurrent/worker/TaskWorkerStates;", "todo", "", "plusAssign", "runnable", "Lkotlin/Function1;", "Lde/bixilon/kutil/latch/CountUpAndDownLatch;", "work", "progress", "kutil"})
public final class TaskWorker {
    @NotNull
    private Function2<? super Task, ? super Throwable, Unit> errorHandler;
    @NotNull
    private Function2<? super Task, ? super Throwable, Unit> criticalErrorHandler;
    @NotNull
    private final Map<Object, Task> todo;
    @NotNull
    private final List<Task> otherTodo;
    @NotNull
    private TaskWorkerStates state;

    public TaskWorker(@NotNull Function2<? super Task, ? super Throwable, Unit> errorHandler, @NotNull Function2<? super Task, ? super Throwable, Unit> criticalErrorHandler) {
        Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
        Intrinsics.checkNotNullParameter(criticalErrorHandler, (String)"criticalErrorHandler");
        this.errorHandler = errorHandler;
        this.criticalErrorHandler = criticalErrorHandler;
        this.todo = CollectionUtil.INSTANCE.synchronizedMapOf(new Pair[0]);
        this.otherTodo = CollectionUtil.INSTANCE.synchronizedListOf(new Task[0]);
        this.state = TaskWorkerStates.PREPARING;
    }

    public /* synthetic */ TaskWorker(Function2 function2, Function2 function22, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function2 = 1.INSTANCE;
        }
        if ((n & 2) != 0) {
            function22 = 2.INSTANCE;
        }
        this((Function2<? super Task, ? super Throwable, Unit>)function2, (Function2<? super Task, ? super Throwable, Unit>)function22);
    }

    @NotNull
    public final Function2<Task, Throwable, Unit> getErrorHandler() {
        return this.errorHandler;
    }

    public final void setErrorHandler(@NotNull Function2<? super Task, ? super Throwable, Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.errorHandler = function2;
    }

    @NotNull
    public final Function2<Task, Throwable, Unit> getCriticalErrorHandler() {
        return this.criticalErrorHandler;
    }

    public final void setCriticalErrorHandler(@NotNull Function2<? super Task, ? super Throwable, Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.criticalErrorHandler = function2;
    }

    @NotNull
    public final TaskWorkerStates getState() {
        return this.state;
    }

    public final void plusAssign(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (!(this.state == TaskWorkerStates.PREPARING)) {
            boolean bl = false;
            String string = "Task worker is already working!";
            throw new IllegalStateException(string.toString());
        }
        if (ArraysKt.contains((Object[])task.getDependencies(), (Object)task.getIdentifier())) {
            throw new IllegalArgumentException("Task can not depend on itself!");
        }
        if (task.getIdentifier() != null) {
            Task previous = this.todo.put(task.getIdentifier(), task);
            if (previous != null) {
                System.err.println("Task " + task.getIdentifier() + " replaced existing task!");
            }
        } else {
            ((Collection)this.otherTodo).add(task);
        }
    }

    public final void plusAssign(@NotNull Function1<? super CountUpAndDownLatch, Unit> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        this.plusAssign(new Task(null, false, 0, null, runnable, 15, null));
    }

    public final synchronized void work(@NotNull CountUpAndDownLatch progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        if (this.state != TaskWorkerStates.PREPARING) {
            throw new IllegalStateException("Invalid state: " + this.state);
        }
        this.state = TaskWorkerStates.STARTED;
        List todo = CollectionsKt.toMutableList(this.todo.values());
        CollectionsKt.addAll((Collection)todo, (Iterable)this.otherTodo);
        CollectionsKt.sortWith((List)todo, TaskWorker::work$lambda-1);
        Set done = new LinkedHashSet();
        SimpleLock doneLock = new SimpleLock();
        Ref.BooleanRef exit = new Ref.BooleanRef();
        CountUpAndDownLatch workerProgress = new CountUpAndDownLatch(1, progress);
        while (!((Collection)todo).isEmpty()) {
            Ref.BooleanRef changed = new Ref.BooleanRef();
            block1: for (Task task : CollectionUtil.INSTANCE.toSynchronizedList(todo)) {
                if (!(task.getDependencies().length == 0)) {
                    doneLock.acquire();
                    for (Object dependency : task.getDependencies()) {
                        if (done.contains(dependency)) continue;
                        doneLock.release();
                        continue block1;
                    }
                    doneLock.release();
                }
                CountUpAndDownLatch taskProgress = new CountUpAndDownLatch(2, workerProgress);
                ((Collection)todo).remove(task);
                DefaultThreadPool.INSTANCE.plusAssign(new ThreadPoolRunnable(task.getPriority(), false, () -> TaskWorker.work$lambda-3(taskProgress, task, changed, this, exit, doneLock, done), 2, null));
            }
            if (exit.element || todo.isEmpty()) break;
            if (changed.element) continue;
            CountUpAndDownLatch.waitForChange$default(workerProgress, 0L, 1, null);
            if (!exit.element) continue;
        }
        workerProgress.dec();
        CountUpAndDownLatch.await$default(workerProgress, 0L, 1, null);
        this.state = TaskWorkerStates.FINISHED;
    }

    public static /* synthetic */ void work$default(TaskWorker taskWorker, CountUpAndDownLatch countUpAndDownLatch, int n, Object object) {
        if ((n & 1) != 0) {
            countUpAndDownLatch = new CountUpAndDownLatch(0, null, 2, null);
        }
        taskWorker.work(countUpAndDownLatch);
    }

    private static final int work$lambda-1(Task a, Task b) {
        return b.getPriority() - a.getPriority();
    }

    private static final void work$lambda-3(CountUpAndDownLatch $taskProgress, Task $task, Ref.BooleanRef $changed, TaskWorker this$0, Ref.BooleanRef $exit, SimpleLock $doneLock, Set $done) {
        Intrinsics.checkNotNullParameter((Object)$taskProgress, (String)"$taskProgress");
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        Intrinsics.checkNotNullParameter((Object)$changed, (String)"$changed");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$exit, (String)"$exit");
        Intrinsics.checkNotNullParameter((Object)$doneLock, (String)"$doneLock");
        Intrinsics.checkNotNullParameter((Object)$done, (String)"$done");
        $taskProgress.dec();
        try {
            $task.getExecutor().invoke((Object)$taskProgress);
            $changed.element = true;
            Object object = $task.getIdentifier();
            if (object != null) {
                Object it = object;
                boolean bl = false;
                $doneLock.lock();
                ((Collection)$done).add(it);
                $doneLock.unlock();
            }
            $taskProgress.dec();
        }
        catch (Throwable exception) {
            if (!(exception instanceof InterruptedException)) {
                exception.printStackTrace();
            }
            $taskProgress.setCount(0);
            $changed.element = true;
            if ($task.getOptional()) {
                this$0.errorHandler.invoke((Object)$task, (Object)exception);
            }
            this$0.criticalErrorHandler.invoke((Object)$task, (Object)exception);
            $exit.element = true;
        }
    }

    public TaskWorker() {
        this(null, null, 3, null);
    }
}

