/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.queue;

import de.bixilon.kutil.concurrent.lock.simple.SimpleLock;
import de.bixilon.kutil.time.TimeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J\u0011\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0007H\u0086\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010\u0018\u001a\u00020\u0003R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lde/bixilon/kutil/concurrent/queue/Queue;", "", "initialCapacity", "", "(I)V", "queue", "", "Ljava/lang/Runnable;", "removeLock", "Lde/bixilon/kutil/concurrent/lock/simple/SimpleLock;", "size", "getSize", "()I", "add", "", "runnable", "clear", "", "plusAssign", "runFirst", "timeWork", "time", "", "work", "maxJobs", "kutil"})
public final class Queue {
    @NotNull
    private final List<Runnable> queue;
    @NotNull
    private SimpleLock removeLock;

    public Queue(int initialCapacity) {
        this.queue = new ArrayList(initialCapacity);
        this.removeLock = new SimpleLock();
    }

    public /* synthetic */ Queue(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 100;
        }
        this(n);
    }

    public final int getSize() {
        return this.queue.size();
    }

    public final boolean add(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        ((Collection)this.queue).add(runnable);
        return true;
    }

    public final void plusAssign(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.add(runnable);
    }

    private final void runFirst() {
        try {
            this.queue.remove(0).run();
        }
        catch (Throwable exception) {
            exception.printStackTrace();
        }
    }

    public final void work(int maxJobs) {
        this.removeLock.lock();
        int jobsDone = 0;
        int cachedSize = this.queue.size();
        while (cachedSize-- > 0 || this.queue.size() > 0) {
            this.runFirst();
            if (jobsDone++ != maxJobs) continue;
        }
        this.removeLock.unlock();
    }

    public static /* synthetic */ void work$default(Queue queue, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = Integer.MAX_VALUE;
        }
        queue.work(n);
    }

    public final void timeWork(long time) {
        if (!(time > 0L)) {
            boolean bl = false;
            String string = "Can not have <= 0 time to do jobs!";
            throw new IllegalStateException(string.toString());
        }
        long start = TimeUtil.INSTANCE.getMillis();
        this.removeLock.lock();
        int cachedSize = this.queue.size();
        while (cachedSize-- > 0 || this.queue.size() > 0) {
            this.runFirst();
            if (TimeUtil.INSTANCE.getMillis() - start < time) continue;
        }
        this.removeLock.unlock();
    }

    public final void clear() {
        this.removeLock.lock();
        this.queue.clear();
        this.removeLock.unlock();
    }

    public Queue() {
        this(0, 1, null);
    }
}

