/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.lock.thread;

import de.bixilon.kutil.concurrent.lock.Lock;
import de.bixilon.kutil.concurrent.lock.NobodyIsReadingException;
import de.bixilon.kutil.concurrent.lock.NobodyIsWritingException;
import de.bixilon.kutil.concurrent.lock.thread.ThreadMissmatchException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0003\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/bixilon/kutil/concurrent/lock/thread/ThreadLock;", "Lde/bixilon/kutil/concurrent/lock/Lock;", "()V", "lock", "Ljava/lang/Object;", "locked", "", "getLocked", "()Z", "<set-?>", "", "readers", "getReaders", "()I", "thread", "Ljava/lang/Thread;", "writers", "acquire", "", "release", "unlock", "kutil"})
public final class ThreadLock
implements Lock {
    @NotNull
    private final Object lock = new Object();
    private int readers;
    @Nullable
    private Thread thread;
    private int writers;

    @Override
    public int getReaders() {
        return this.readers;
    }

    @Override
    public boolean getLocked() {
        return this.writers > 0 && this.thread != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquire() {
        Thread thread = Thread.currentThread();
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            while (this.getLocked() && this.thread != thread) {
                this.lock.wait();
            }
            int n = this.getReaders();
            this.readers = n + 1;
            this.lock.notifyAll();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.getReaders() <= 0) {
                throw new NobodyIsReadingException();
            }
            int n = this.getReaders();
            this.readers = n + -1;
            this.lock.notifyAll();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock() {
        Thread thread = Thread.currentThread();
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            while (this.getReaders() > 0) {
                this.lock.wait();
            }
            if (this.thread != thread) {
                while (this.writers > 0) {
                    this.lock.wait();
                }
                this.thread = thread;
            }
            int n = this.writers;
            this.writers = n + 1;
            this.lock.notifyAll();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() {
        Thread thread = this.thread;
        Thread currentThread = Thread.currentThread();
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.writers <= 0 || thread == null) {
                throw new NobodyIsWritingException();
            }
            if (this.thread != currentThread) {
                Intrinsics.checkNotNullExpressionValue((Object)currentThread, (String)"currentThread");
                throw new ThreadMissmatchException(thread, currentThread);
            }
            int n = this.writers;
            this.writers = n + -1;
            if (this.writers <= 0) {
                this.thread = null;
            }
            this.lock.notifyAll();
            Unit unit = Unit.INSTANCE;
        }
    }
}

