/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.watcher;

import de.bixilon.kutil.cast.CastUtil;
import de.bixilon.kutil.watcher.WatcherReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty0;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0002\b\u0003 \u0005*\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0002\b\u0003 \u0005*\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0002\b\u0003 \u0005*\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0002\b\u0003 \u0005*\b\u0012\u0002\b\u0003\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f*\u0006\u0012\u0002\b\u00030\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0013\u001a\u0004\u0018\u00010\u0001*\u0006\u0012\u0002\b\u00030\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0019\u0010\u0017\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0019\u0010\u001a\u001a\u00020\u001b*\u0006\u0012\u0002\b\u00030\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0019\u0010\u001e\u001a\u00020\u001f*\u0006\u0012\u0002\b\u00030 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001d\u0010#\u001a\u0006\u0012\u0002\b\u00030\u0004*\u0006\u0012\u0002\b\u00030\u000f8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0019\u0010&\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00108F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lde/bixilon/kutil/watcher/WatchUtil;", "", "()V", "CLASS", "Ljava/lang/Class;", "kotlin.jvm.PlatformType", "CONTAINER_FIELD", "Ljava/lang/reflect/Field;", "DELEGATE_SOURCE_FIELD", "JCLASS_FIELD", "KCLASS_CLASS", "MUTABLE_PROPERTY_1_CLASS", "PROPERTY_1_CLASS", "RECEIVER_FIELD", "container", "Lkotlin/reflect/KClass;", "Lkotlin/reflect/KProperty;", "getContainer", "(Lkotlin/reflect/KProperty;)Lkotlin/reflect/KClass;", "delegate", "Lkotlin/reflect/KProperty0;", "getDelegate", "(Lkotlin/reflect/KProperty0;)Ljava/lang/Object;", "delegateSourceField", "getDelegateSourceField", "(Lkotlin/reflect/KProperty;)Ljava/lang/reflect/Field;", "identifier", "", "getIdentifier", "(Lkotlin/reflect/KProperty;)Ljava/lang/String;", "invalid", "", "Ljava/lang/ref/WeakReference;", "getInvalid", "(Ljava/lang/ref/WeakReference;)Z", "jClass", "getJClass", "(Lkotlin/reflect/KClass;)Ljava/lang/Class;", "receiver", "getReceiver", "(Lkotlin/reflect/KProperty;)Ljava/lang/Object;", "kutil"})
public final class WatchUtil {
    @NotNull
    public static final WatchUtil INSTANCE = new WatchUtil();
    private static final Class<?> CLASS = Class.forName("kotlin.jvm.internal.CallableReference");
    private static final Field RECEIVER_FIELD = CLASS.getDeclaredField("receiver");
    private static final Class<?> PROPERTY_1_CLASS = Class.forName("kotlin.reflect.jvm.internal.KPropertyImpl");
    private static final Field CONTAINER_FIELD = PROPERTY_1_CLASS.getDeclaredField("container");
    private static final Class<?> MUTABLE_PROPERTY_1_CLASS = Class.forName("kotlin.reflect.jvm.internal.KProperty1Impl");
    private static final Field DELEGATE_SOURCE_FIELD = MUTABLE_PROPERTY_1_CLASS.getDeclaredField("delegateSource");
    private static final Class<?> KCLASS_CLASS = Class.forName("kotlin.reflect.jvm.internal.KClassImpl");
    private static final Field JCLASS_FIELD = KCLASS_CLASS.getDeclaredField("jClass");

    private WatchUtil() {
    }

    public final boolean getInvalid(@NotNull WeakReference<?> $this$invalid) {
        Intrinsics.checkNotNullParameter($this$invalid, (String)"<this>");
        Object t = $this$invalid.get();
        if (t == null) {
            return true;
        }
        Object referenceValue = t;
        if (referenceValue instanceof WatcherReference && ((WatcherReference)CastUtil.INSTANCE.unsafeCast(referenceValue)).isValid(referenceValue)) {
            return false;
        }
        return false;
    }

    @NotNull
    public final Object getReceiver(@NotNull KProperty<?> $this$receiver) {
        Intrinsics.checkNotNullParameter($this$receiver, (String)"<this>");
        Object object = RECEIVER_FIELD.get($this$receiver);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"RECEIVER_FIELD.get(this)");
        return object;
    }

    @NotNull
    public final KClass<?> getContainer(@NotNull KProperty<?> $this$container) {
        Intrinsics.checkNotNullParameter($this$container, (String)"<this>");
        return (KClass)CastUtil.INSTANCE.unsafeCast(CONTAINER_FIELD.get($this$container));
    }

    @NotNull
    public final Class<?> getJClass(@NotNull KClass<?> $this$jClass) {
        Intrinsics.checkNotNullParameter($this$jClass, (String)"<this>");
        return (Class)CastUtil.INSTANCE.unsafeCast(JCLASS_FIELD.get($this$jClass));
    }

    @NotNull
    public final String getIdentifier(@NotNull KProperty<?> $this$identifier) {
        String string;
        Intrinsics.checkNotNullParameter($this$identifier, (String)"<this>");
        KProperty<?> kProperty = $this$identifier;
        if (kProperty instanceof KProperty0) {
            string = this.getReceiver($this$identifier).getClass().getName() + ":" + $this$identifier.getName();
        } else if (kProperty instanceof KProperty1) {
            string = this.getJClass(this.getContainer($this$identifier)).getName() + ":" + $this$identifier.getName();
        } else {
            String string2 = "Can not identify " + $this$identifier;
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }
        return string;
    }

    @NotNull
    public final Field getDelegateSourceField(@NotNull KProperty<?> $this$delegateSourceField) {
        Intrinsics.checkNotNullParameter($this$delegateSourceField, (String)"<this>");
        Object lazy = DELEGATE_SOURCE_FIELD.get($this$delegateSourceField);
        return (Field)CastUtil.INSTANCE.unsafeCast(((Lazy)CastUtil.INSTANCE.unsafeCast(lazy)).getValue());
    }

    @Nullable
    public final Object getDelegate(@NotNull KProperty0<?> $this$delegate) {
        Intrinsics.checkNotNullParameter($this$delegate, (String)"<this>");
        Object object = $this$delegate.getDelegate();
        if (object != null) {
            Object it = object;
            boolean bl = false;
            return it;
        }
        try {
            Object v0;
            CastUtil castUtil;
            Object receiver;
            block4: {
                receiver = this.getReceiver((KProperty)$this$delegate);
                Iterable it = KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass(receiver.getClass()));
                castUtil = CastUtil.INSTANCE;
                Iterable iterable = it;
                for (Object t : iterable) {
                    KProperty1 it2 = (KProperty1)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it2.getName(), (Object)$this$delegate.getName())) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            KProperty1 property = (KProperty1)castUtil.unsafeCast(v0);
            Field delegateSourceField = this.getDelegateSourceField((KProperty)property);
            delegateSourceField.setAccessible(true);
            return property.getDelegate(receiver);
        }
        catch (Throwable error) {
            error.printStackTrace();
            System.err.println("Can not get delegate for " + $this$delegate + ". Is it an observable property?");
            return null;
        }
    }

    static {
        RECEIVER_FIELD.setAccessible(true);
        CONTAINER_FIELD.setAccessible(true);
        DELEGATE_SOURCE_FIELD.setAccessible(true);
        JCLASS_FIELD.setAccessible(true);
    }
}

