/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.unit;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000bJ+\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0014J\n\u0010\u0015\u001a\u00020\u0005*\u00020\u000bR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lde/bixilon/kutil/unit/UnitFormatter;", "", "()V", "BYTE_UNITS", "", "", "[Ljava/lang/String;", "TIME_UNITS", "UNITS", "formatMillis", "millis", "", "formatNanos", "nanos", "formatNumber", "number", "", "formatUnit", "units", "factor", "(J[Ljava/lang/String;J)Ljava/lang/String;", "formatBytes", "kutil"})
public final class UnitFormatter {
    @NotNull
    public static final UnitFormatter INSTANCE = new UnitFormatter();
    @NotNull
    private static final String[] BYTE_UNITS;
    @NotNull
    private static final String[] UNITS;
    @NotNull
    private static final String[] TIME_UNITS;

    private UnitFormatter() {
    }

    @NotNull
    public final String formatBytes(long $this$formatBytes) {
        if ($this$formatBytes < 0L) {
            return "Unknown";
        }
        return this.formatUnit($this$formatBytes, BYTE_UNITS, 1024L);
    }

    @NotNull
    public final String formatNumber(int number) {
        return this.formatNumber((long)number);
    }

    @NotNull
    public final String formatNumber(long number) {
        return this.formatUnit(number, UNITS, 1000L);
    }

    private final String formatUnit(long number, String[] units, long factor) {
        long lastFactor = 1L;
        long currentFactor = factor;
        for (String unit : units) {
            if (number < currentFactor) {
                if (number < lastFactor * (long)10) {
                    String string = "%.1f";
                    Object[] objectArray = new Object[]{Float.valueOf((float)number / (float)lastFactor)};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
                    return string2 + unit;
                }
                return number / lastFactor + unit;
            }
            lastFactor = currentFactor;
            currentFactor *= factor;
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    public final String formatNanos(long nanos) {
        return nanos / (long)1000000 + "ms";
    }

    @NotNull
    public final String formatMillis(long millis) {
        return this.formatNanos(millis * (long)1000);
    }

    static {
        String[] stringArray = new String[]{"B", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB", "ZiB", "YiB"};
        BYTE_UNITS = stringArray;
        stringArray = new String[]{"", "k", "M", "G", "T", "P", "E", "Z", "Y"};
        UNITS = stringArray;
        stringArray = new String[]{"ns", "\u03bcs", "ms", "s", "m", "h", "d", "w", "M", "Y"};
        TIME_UNITS = stringArray;
    }
}

