/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.file.watcher;

import de.bixilon.kutil.cast.CastUtil;
import de.bixilon.kutil.collections.CollectionUtil;
import de.bixilon.kutil.collections.map.SynchronizedMap;
import de.bixilon.kutil.concurrent.pool.DefaultThreadPool;
import de.bixilon.kutil.file.watcher.FileWatcher;
import de.bixilon.kutil.file.watcher.FileWatcherService;
import de.bixilon.kutil.latch.CountUpAndDownLatch;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00042\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0007J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0007J\u0006\u0010\u0017\u001a\u00020\u000fJ\u0006\u0010\n\u001a\u00020\u000fR&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/bixilon/kutil/file/watcher/FileWatcherService;", "", "()V", "WATCHERS", "Lde/bixilon/kutil/collections/map/SynchronizedMap;", "Ljava/nio/file/WatchKey;", "", "Lde/bixilon/kutil/file/watcher/FileWatcher;", "service", "Ljava/nio/file/WatchService;", "stop", "", "thread", "Ljava/lang/Thread;", "notifyChange", "", "watchers", "event", "Ljava/nio/file/WatchEvent;", "fileName", "register", "fileWatcher", "registerWait", "start", "kutil"})
public final class FileWatcherService {
    @NotNull
    public static final FileWatcherService INSTANCE = new FileWatcherService();
    @NotNull
    private static final SynchronizedMap<WatchKey, SynchronizedMap<String, FileWatcher>> WATCHERS = CollectionUtil.INSTANCE.synchronizedMapOf(new Pair[0]);
    private static boolean stop;
    @Nullable
    private static WatchService service;
    private static Thread thread;

    private FileWatcherService() {
    }

    public final void start() {
        if (service != null) {
            throw new IllegalStateException("Already running!");
        }
        stop = false;
        CountUpAndDownLatch latch = new CountUpAndDownLatch(1, null, 2, null);
        thread = new Thread(() -> FileWatcherService.start$lambda-1(this, latch), "FileWatcherService");
        Thread thread = FileWatcherService.thread;
        if (thread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"thread");
            thread = null;
        }
        thread.start();
        CountUpAndDownLatch.await$default(latch, 0L, 1, null);
    }

    private final void notifyChange(SynchronizedMap<String, FileWatcher> watchers, WatchEvent<?> event, String fileName) {
        try {
            Unit unit;
            Function2<WatchEvent<?>, String, Unit> function2 = watchers.get(fileName);
            if (function2 != null && (function2 = function2.getCallback()) != null) {
                function2.invoke(event, (Object)fileName);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                return;
            }
        }
        catch (Throwable exception) {
            exception.printStackTrace();
        }
    }

    public final void register(@NotNull FileWatcher fileWatcher) {
        Intrinsics.checkNotNullParameter((Object)fileWatcher, (String)"fileWatcher");
        DefaultThreadPool.INSTANCE.plusAssign(() -> FileWatcherService.register$lambda-2(fileWatcher));
    }

    public final void registerWait(@NotNull FileWatcher fileWatcher) {
        Intrinsics.checkNotNullParameter((Object)fileWatcher, (String)"fileWatcher");
        WatchService watchService = service;
        if (watchService == null) {
            throw new IllegalStateException("File watcher service not running!");
        }
        WatchService service = watchService;
        WatchKey watchKey = null;
        try {
            File file;
            File parent = file = fileWatcher.getPath().toFile();
            if (parent.isFile()) {
                parent = parent.getParentFile();
            }
            if (!parent.isDirectory()) {
                throw new IllegalStateException("Can not watch directory: " + parent.getPath());
            }
            Path parentPath = parent.toPath();
            Object object = fileWatcher.getTypes();
            watchKey = parentPath.register(service, Arrays.copyOf(object, ((WatchEvent.Kind<?>[])object).length));
            object = WATCHERS.synchronizedGetOrPut(watchKey, (Function0<SynchronizedMap<String, FileWatcher>>)((Function0)registerWait.1.INSTANCE));
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
            Intrinsics.checkNotNullExpressionValue((Object)parentPath, (String)"parentPath");
            object.put(StringsKt.removePrefix((String)StringsKt.removePrefix((String)string, (CharSequence)((Object)parentPath).toString()), (CharSequence)"/"), fileWatcher);
        }
        catch (Exception exception) {
            TypeIntrinsics.asMutableMap((Object)WATCHERS).remove(watchKey);
            throw exception;
        }
    }

    public final void stop() {
        if (service == null) {
            return;
        }
        stop = true;
        Thread thread = FileWatcherService.thread;
        if (thread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"thread");
            thread = null;
        }
        thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void start$lambda-1(FileWatcherService this$0, CountUpAndDownLatch $latch) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$latch, (String)"$latch");
        try {
            WatchService service;
            FileWatcherService.service = service = FileSystems.getDefault().newWatchService();
            $latch.dec();
            while (true) {
                WatchKey watchKey;
                Intrinsics.checkNotNullExpressionValue((Object)service.take(), (String)"service.take()");
                if (stop) break;
                for (WatchEvent<?> event : watchKey.pollEvents()) {
                    Path path;
                    SynchronizedMap<String, FileWatcher> it;
                    CastUtil castUtil = CastUtil.INSTANCE;
                    Object $this$nullCast$iv = event.context();
                    boolean $i$f$nullCast = false;
                    if ((Path)($this$nullCast$iv instanceof Path ? $this$nullCast$iv : null) == null) continue;
                    if (WATCHERS.get(watchKey) == null) continue;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue(event, (String)"event");
                    INSTANCE.notifyChange(it, event, ((Object)path).toString());
                }
                watchKey.reset();
            }
            for (WatchKey watchKey : WATCHERS.keySet()) {
                watchKey.cancel();
            }
            WATCHERS.clear();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if ($latch.getCount() > 0) {
                $latch.dec();
            }
            service = null;
        }
    }

    private static final void register$lambda-2(FileWatcher $fileWatcher) {
        Intrinsics.checkNotNullParameter((Object)$fileWatcher, (String)"$fileWatcher");
        INSTANCE.registerWait($fileWatcher);
    }
}

