/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.watcher.set;

import de.bixilon.kutil.watcher.set.SetChange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.markers.KMutableSet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0010)\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0016J \u0010\u0019\u001a\u00020\u00112\u0018\u0010\u001a\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0010\u0012\u0004\u0012\u00020\u00110\u000fJ\b\u0010\u001b\u001a\u00020\u0011H\u0016J\u0016\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u001d\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0016J\b\u0010\u001e\u001a\u00020\u0013H\u0016J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000 H\u0096\u0002J\u0016\u0010!\u001a\u00020\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0002J\u0015\u0010#\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010$\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0016J\u0016\u0010%\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8VX\u0096\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f*\u0004\b\t\u0010\nR&\u0010\r\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lde/bixilon/kutil/watcher/set/ObservedSet;", "V", "", "original", "(Ljava/util/Set;)V", "emptySet", "", "size", "", "getSize$delegate", "(Lde/bixilon/kutil/watcher/set/ObservedSet;)Ljava/lang/Object;", "getSize", "()I", "watchers", "", "Lkotlin/Function1;", "Lde/bixilon/kutil/watcher/set/SetChange;", "", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "addWatcher", "watcher", "clear", "contains", "containsAll", "isEmpty", "iterator", "", "notifyWatchers", "change", "remove", "removeAll", "retainAll", "kutil"})
public final class ObservedSet<V>
implements Set<V>,
KMutableSet {
    @NotNull
    private final Set<V> original;
    @NotNull
    private final List<Function1<SetChange<V>, Unit>> watchers;
    @NotNull
    private final Set<V> emptySet;

    public ObservedSet(@NotNull Set<V> original) {
        Intrinsics.checkNotNullParameter(original, (String)"original");
        this.original = original;
        this.watchers = new ArrayList();
        this.emptySet = SetsKt.emptySet();
    }

    public int getSize() {
        return this.original.size();
    }

    public static Object getSize$delegate(ObservedSet<Object> observedSet) {
        Intrinsics.checkNotNullParameter(observedSet, (String)"<this>");
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl(observedSet.original, Set.class, "size", "size()I", 0)));
    }

    public final void addWatcher(@NotNull Function1<? super SetChange<V>, Unit> watcher) {
        Intrinsics.checkNotNullParameter(watcher, (String)"watcher");
        ((Collection)this.watchers).add(watcher);
    }

    private final void notifyWatchers(SetChange<V> change) {
        for (Function1<SetChange<V>, Unit> watcher : this.watchers) {
            watcher.invoke(change);
        }
    }

    @Override
    public boolean add(V element) {
        boolean added = this.original.add(element);
        if (added) {
            this.notifyWatchers(new SetChange(SetsKt.setOf(element), (Collection)this.emptySet));
        }
        return added;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends V> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean add = this.original.addAll(elements);
        if (!add) {
            return false;
        }
        this.notifyWatchers(new SetChange<V>(elements, (Collection)this.emptySet));
        return true;
    }

    @Override
    public void clear() {
        this.notifyWatchers(new SetChange((Collection)this.emptySet, CollectionsKt.toSet((Iterable)this.original)));
        this.original.clear();
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        return this.original.iterator();
    }

    @Override
    public boolean remove(Object element) {
        boolean removed = this.original.remove(element);
        if (!removed) {
            return false;
        }
        this.notifyWatchers(new SetChange((Collection)this.emptySet, SetsKt.setOf((Object)element)));
        return true;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean removed = this.original.removeAll(elements);
        if (!removed) {
            return false;
        }
        this.notifyWatchers(new SetChange<Object>((Collection)this.emptySet, elements));
        return true;
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean retained = this.original.retainAll(elements);
        if (!retained) {
            return false;
        }
        System.out.println((Object)"Kutil: Set::retainAll is not observed yet!");
        return true;
    }

    @Override
    public boolean contains(Object element) {
        return this.original.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.original.containsAll(elements);
    }

    @Override
    public boolean isEmpty() {
        return this.original.isEmpty();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

