/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.watcher.map;

import de.bixilon.kutil.cast.CastUtil;
import de.bixilon.kutil.concurrent.lock.simple.SimpleLock;
import de.bixilon.kutil.watcher.WatchUtil;
import de.bixilon.kutil.watcher.map.MapChange;
import de.bixilon.kutil.watcher.map.ObservedMap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KCallable;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty0;
import kotlin.reflect.jvm.KCallablesJvm;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00050\u0003:\u0001\u001bB\u0019\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J)\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u00042\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0096\u0002J1\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00042\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005H\u0096\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R?\u0010\r\u001a0\u0012,\u0012*\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u001c\u0012\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0012\u0012\u0004\u0012\u00020\u00130\u00110\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lde/bixilon/kutil/watcher/map/MapDataWatcher;", "K", "V", "Lkotlin/properties/ReadWriteProperty;", "", "", "value", "(Ljava/util/Map;)V", "lock", "Lde/bixilon/kutil/concurrent/lock/simple/SimpleLock;", "getLock", "()Lde/bixilon/kutil/concurrent/lock/simple/SimpleLock;", "Lde/bixilon/kutil/watcher/map/ObservedMap;", "watchers", "", "Lkotlin/Pair;", "Ljava/lang/ref/WeakReference;", "Lkotlin/Function1;", "Lde/bixilon/kutil/watcher/map/MapChange;", "", "getWatchers", "()Ljava/util/List;", "getValue", "thisRef", "property", "Lkotlin/reflect/KProperty;", "setValue", "Companion", "kutil"})
public final class MapDataWatcher<K, V>
implements ReadWriteProperty<Object, Map<K, V>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Pair<WeakReference<?>, Function1<MapChange<K, V>, Unit>>> watchers;
    @NotNull
    private final ObservedMap<K, V> value;
    @NotNull
    private final SimpleLock lock;

    public MapDataWatcher(@NotNull Map<K, V> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.watchers = new ArrayList();
        this.value = new ObservedMap<K, V>(value);
        this.lock = new SimpleLock();
        this.value.addWatcher((Function1)new Function1<MapChange<K, V>, Unit>(){

            public final void invoke(@NotNull MapChange<K, V> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Set toRemove = new LinkedHashSet();
                this.getLock().acquire();
                for (Pair pair : this.getWatchers()) {
                    WeakReference reference = (WeakReference)pair.component1();
                    Function1 observer = (Function1)pair.component2();
                    if (WatchUtil.INSTANCE.getInvalid(reference)) {
                        ((Collection)toRemove).add(pair);
                        continue;
                    }
                    try {
                        observer.invoke(it);
                    }
                    catch (Throwable exception) {
                        exception.printStackTrace();
                    }
                }
                this.getLock().release();
                if (!((Collection)toRemove).isEmpty()) {
                    this.getLock().lock();
                    CollectionsKt.removeAll((Collection)this.getWatchers(), (Iterable)toRemove);
                    this.getLock().unlock();
                }
            }
        });
    }

    @NotNull
    public final List<Pair<WeakReference<?>, Function1<MapChange<K, V>, Unit>>> getWatchers() {
        return this.watchers;
    }

    @NotNull
    public final SimpleLock getLock() {
        return this.lock;
    }

    @NotNull
    public Map<K, V> getValue(@NotNull Object thisRef, @NotNull KProperty<?> property) {
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return this.value;
    }

    public void setValue(@NotNull Object thisRef, @NotNull KProperty<?> property, @NotNull Map<K, V> value) {
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (Intrinsics.areEqual(this.value, value)) {
            return;
        }
        this.value.clear();
        this.value.putAll(value);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0002\u0010\u0005\"\u0004\b\u0003\u0010\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\bJP\u0010\t\u001a\u00020\n\"\u0004\b\u0002\u0010\u0005\"\u0004\b\u0003\u0010\u0006*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\f0\u000b2\u0006\u0010\r\u001a\u00020\u00012\u001e\u0010\u000e\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0010\u0012\u0004\u0012\u00020\n0\u000fJ5\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0002\u0010\u0005\"\u0004\b\u0003\u0010\u0006*\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\bH\u0007\u00a2\u0006\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lde/bixilon/kutil/watcher/map/MapDataWatcher$Companion;", "", "()V", "watchedMap", "Lde/bixilon/kutil/watcher/map/MapDataWatcher;", "K", "V", "value", "", "observeMap", "", "Lkotlin/reflect/KProperty0;", "", "owner", "observer", "Lkotlin/Function1;", "Lde/bixilon/kutil/watcher/map/MapChange;", "watchedMap1", "kutil"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <K, V> MapDataWatcher<K, V> watchedMap(@NotNull Map<K, V> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return new MapDataWatcher<K, V>(value);
        }

        @JvmName(name="watchedMap1")
        @NotNull
        public final <K, V> MapDataWatcher<K, V> watchedMap1(@NotNull Map<K, V> $this$watchedMap) {
            Intrinsics.checkNotNullParameter($this$watchedMap, (String)"<this>");
            return this.watchedMap($this$watchedMap);
        }

        public final <K, V> void observeMap(@NotNull KProperty0<? extends Map<K, ? extends V>> $this$observeMap, @NotNull Object owner, @NotNull Function1<? super MapChange<K, V>, Unit> observer) {
            Intrinsics.checkNotNullParameter($this$observeMap, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter(observer, (String)"observer");
            KCallablesJvm.setAccessible((KCallable)((KCallable)$this$observeMap), (boolean)true);
            MapDataWatcher delegate = (MapDataWatcher)CastUtil.INSTANCE.unsafeCast(WatchUtil.INSTANCE.getDelegate($this$observeMap));
            WeakReference<Object> reference = new WeakReference<Object>(owner);
            delegate.getLock().lock();
            ((Collection)delegate.getWatchers()).add(new Pair(reference, observer));
            delegate.getLock().unlock();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

